// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.document_ai.v1.model;

import com.google.gson.annotations.SerializedName;

public class BankEntity {
    /**
     * 账户名
     * <p> 示例值：北京字节跳动网络技术有限公司
     */
    @SerializedName("account_name")
    private String accountName;
    /**
     * 银行名称
     * <p> 示例值：中国农业银行北京和平里支行
     */
    @SerializedName("bank_name")
    private String bankName;
    /**
     * 账户ID
     * <p> 示例值：1123012345004701
     */
    @SerializedName("account_number")
    private String accountNumber;
    /**
     * 电话
     * <p> 示例值：010-81234688
     */
    @SerializedName("phone")
    private String phone;
    /**
     * 联系人
     * <p> 示例值：张三
     */
    @SerializedName("contacts")
    private String contacts;
    /**
     * 传真号码
     * <p> 示例值：91110112345684235
     */
    @SerializedName("tax_number")
    private String taxNumber;
    /**
     * 联系地址
     * <p> 示例值：A市B区C园D楼3-8
     */
    @SerializedName("address")
    private String address;
    /**
     * id号
     * <p> 示例值：1123012345004701
     */
    @SerializedName("id_number")
    private String idNumber;
    /**
     * 邮箱
     * <p> 示例值：zhangsan.1111@bytedance.com
     */
    @SerializedName("email")
    private String email;

    // builder 开始
    public BankEntity() {
    }

    public BankEntity(Builder builder) {
        /**
         * 账户名
         * <p> 示例值：北京字节跳动网络技术有限公司
         */
        this.accountName = builder.accountName;
        /**
         * 银行名称
         * <p> 示例值：中国农业银行北京和平里支行
         */
        this.bankName = builder.bankName;
        /**
         * 账户ID
         * <p> 示例值：1123012345004701
         */
        this.accountNumber = builder.accountNumber;
        /**
         * 电话
         * <p> 示例值：010-81234688
         */
        this.phone = builder.phone;
        /**
         * 联系人
         * <p> 示例值：张三
         */
        this.contacts = builder.contacts;
        /**
         * 传真号码
         * <p> 示例值：91110112345684235
         */
        this.taxNumber = builder.taxNumber;
        /**
         * 联系地址
         * <p> 示例值：A市B区C园D楼3-8
         */
        this.address = builder.address;
        /**
         * id号
         * <p> 示例值：1123012345004701
         */
        this.idNumber = builder.idNumber;
        /**
         * 邮箱
         * <p> 示例值：zhangsan.1111@bytedance.com
         */
        this.email = builder.email;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public static class Builder {
        /**
         * 账户名
         * <p> 示例值：北京字节跳动网络技术有限公司
         */
        private String accountName;
        /**
         * 银行名称
         * <p> 示例值：中国农业银行北京和平里支行
         */
        private String bankName;
        /**
         * 账户ID
         * <p> 示例值：1123012345004701
         */
        private String accountNumber;
        /**
         * 电话
         * <p> 示例值：010-81234688
         */
        private String phone;
        /**
         * 联系人
         * <p> 示例值：张三
         */
        private String contacts;
        /**
         * 传真号码
         * <p> 示例值：91110112345684235
         */
        private String taxNumber;
        /**
         * 联系地址
         * <p> 示例值：A市B区C园D楼3-8
         */
        private String address;
        /**
         * id号
         * <p> 示例值：1123012345004701
         */
        private String idNumber;
        /**
         * 邮箱
         * <p> 示例值：zhangsan.1111@bytedance.com
         */
        private String email;

        /**
         * 账户名
         * <p> 示例值：北京字节跳动网络技术有限公司
         *
         * @param accountName
         * @return
         */
        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }


        /**
         * 银行名称
         * <p> 示例值：中国农业银行北京和平里支行
         *
         * @param bankName
         * @return
         */
        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }


        /**
         * 账户ID
         * <p> 示例值：1123012345004701
         *
         * @param accountNumber
         * @return
         */
        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }


        /**
         * 电话
         * <p> 示例值：010-81234688
         *
         * @param phone
         * @return
         */
        public Builder phone(String phone) {
            this.phone = phone;
            return this;
        }


        /**
         * 联系人
         * <p> 示例值：张三
         *
         * @param contacts
         * @return
         */
        public Builder contacts(String contacts) {
            this.contacts = contacts;
            return this;
        }


        /**
         * 传真号码
         * <p> 示例值：91110112345684235
         *
         * @param taxNumber
         * @return
         */
        public Builder taxNumber(String taxNumber) {
            this.taxNumber = taxNumber;
            return this;
        }


        /**
         * 联系地址
         * <p> 示例值：A市B区C园D楼3-8
         *
         * @param address
         * @return
         */
        public Builder address(String address) {
            this.address = address;
            return this;
        }


        /**
         * id号
         * <p> 示例值：1123012345004701
         *
         * @param idNumber
         * @return
         */
        public Builder idNumber(String idNumber) {
            this.idNumber = idNumber;
            return this;
        }


        /**
         * 邮箱
         * <p> 示例值：zhangsan.1111@bytedance.com
         *
         * @param email
         * @return
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }


        public BankEntity build() {
            return new BankEntity(this);
        }
    }
}
