// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.helpdesk.v1.model;

import com.google.gson.annotations.SerializedName;

public class AgentSkillRule {
    /**
     * rule id, 参考[获取客服技能rules](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/helpdesk-v1/agent_skill_rule/list) 用于获取rules options
     * <p> 示例值：test-skill-id
     */
    @SerializedName("id")
    private String id;
    /**
     * 运算符比较, 参考[客服技能运算符选项](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
     * <p> 示例值：8
     */
    @SerializedName("selected_operator")
    private Integer selectedOperator;
    /**
     * rule操作数value，[客服技能及运算符](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
     * <p> 示例值：[3]
     */
    @SerializedName("operator_options")
    private Integer[] operatorOptions;
    /**
     * rule 操作数的值
     * <p> 示例值：{;                "selected_departments": [;                    {;                        "id": "部门ID",;                        "name": "IT";                    };                ];            }
     */
    @SerializedName("operand")
    private String operand;
    /**
     * rule 类型，1-知识库，2-工单信息，3-用户飞书信息
     * <p> 示例值：3
     */
    @SerializedName("category")
    private Integer category;
    /**
     * rule 名
     * <p> 示例值：中文知识库分类
     */
    @SerializedName("display_name")
    private String displayName;

    // builder 开始
    public AgentSkillRule() {
    }

    public AgentSkillRule(Builder builder) {
        /**
         * rule id, 参考[获取客服技能rules](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/helpdesk-v1/agent_skill_rule/list) 用于获取rules options
         * <p> 示例值：test-skill-id
         */
        this.id = builder.id;
        /**
         * 运算符比较, 参考[客服技能运算符选项](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
         * <p> 示例值：8
         */
        this.selectedOperator = builder.selectedOperator;
        /**
         * rule操作数value，[客服技能及运算符](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
         * <p> 示例值：[3]
         */
        this.operatorOptions = builder.operatorOptions;
        /**
         * rule 操作数的值
         * <p> 示例值：{;                "selected_departments": [;                    {;                        "id": "部门ID",;                        "name": "IT";                    };                ];            }
         */
        this.operand = builder.operand;
        /**
         * rule 类型，1-知识库，2-工单信息，3-用户飞书信息
         * <p> 示例值：3
         */
        this.category = builder.category;
        /**
         * rule 名
         * <p> 示例值：中文知识库分类
         */
        this.displayName = builder.displayName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getSelectedOperator() {
        return this.selectedOperator;
    }

    public void setSelectedOperator(Integer selectedOperator) {
        this.selectedOperator = selectedOperator;
    }

    public Integer[] getOperatorOptions() {
        return this.operatorOptions;
    }

    public void setOperatorOptions(Integer[] operatorOptions) {
        this.operatorOptions = operatorOptions;
    }

    public String getOperand() {
        return this.operand;
    }

    public void setOperand(String operand) {
        this.operand = operand;
    }

    public Integer getCategory() {
        return this.category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static class Builder {
        /**
         * rule id, 参考[获取客服技能rules](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/helpdesk-v1/agent_skill_rule/list) 用于获取rules options
         * <p> 示例值：test-skill-id
         */
        private String id;
        /**
         * 运算符比较, 参考[客服技能运算符选项](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
         * <p> 示例值：8
         */
        private Integer selectedOperator;
        /**
         * rule操作数value，[客服技能及运算符](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
         * <p> 示例值：[3]
         */
        private Integer[] operatorOptions;
        /**
         * rule 操作数的值
         * <p> 示例值：{;                "selected_departments": [;                    {;                        "id": "部门ID",;                        "name": "IT";                    };                ];            }
         */
        private String operand;
        /**
         * rule 类型，1-知识库，2-工单信息，3-用户飞书信息
         * <p> 示例值：3
         */
        private Integer category;
        /**
         * rule 名
         * <p> 示例值：中文知识库分类
         */
        private String displayName;

        /**
         * rule id, 参考[获取客服技能rules](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/helpdesk-v1/agent_skill_rule/list) 用于获取rules options
         * <p> 示例值：test-skill-id
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 运算符比较, 参考[客服技能运算符选项](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
         * <p> 示例值：8
         *
         * @param selectedOperator
         * @return
         */
        public Builder selectedOperator(Integer selectedOperator) {
            this.selectedOperator = selectedOperator;
            return this;
        }


        /**
         * rule操作数value，[客服技能及运算符](https://open.feishu.cn/document/ukTMukTMukTM/ucDOyYjL3gjM24yN4IjN/operator-options)
         * <p> 示例值：[3]
         *
         * @param operatorOptions
         * @return
         */
        public Builder operatorOptions(Integer[] operatorOptions) {
            this.operatorOptions = operatorOptions;
            return this;
        }


        /**
         * rule 操作数的值
         * <p> 示例值：{;                "selected_departments": [;                    {;                        "id": "部门ID",;                        "name": "IT";                    };                ];            }
         *
         * @param operand
         * @return
         */
        public Builder operand(String operand) {
            this.operand = operand;
            return this;
        }


        /**
         * rule 类型，1-知识库，2-工单信息，3-用户飞书信息
         * <p> 示例值：3
         *
         * @param category
         * @return
         */
        public Builder category(Integer category) {
            this.category = category;
            return this;
        }


        /**
         * rule 名
         * <p> 示例值：中文知识库分类
         *
         * @param displayName
         * @return
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        public AgentSkillRule build() {
            return new AgentSkillRule(this);
        }
    }
}
