// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.service.hire.v1.resource.*;

public class V1 {
    private final Application application; // 投递
    private final ApplicationInterview applicationInterview; // application.interview
    private final Attachment attachment; // 附件
    private final EcoAccount ecoAccount; // 事件
    private final EcoAccountCustomField ecoAccountCustomField; // 生态对接账号自定义字段
    private final EcoBackgroundCheck ecoBackgroundCheck; // 背调订单
    private final EcoBackgroundCheckCustomField ecoBackgroundCheckCustomField; // 背调自定义字段
    private final EcoBackgroundCheckPackage ecoBackgroundCheckPackage; // 背调套餐和附加调查项
    private final EcoExam ecoExam; // eco_exam
    private final EcoExamPaper ecoExamPaper; // eco_exam_paper
    private final EhrImportTask ehrImportTask; // 导入 e-HR
    private final EhrImportTaskForInternshipOffer ehrImportTaskForInternshipOffer; // ehr_import_task_for_internship_offer
    private final Employee employee; // 入职
    private final Evaluation evaluation; // 评估（灰度租户可见）
    private final ExternalApplication externalApplication; // 导入外部系统信息（灰度租户可见）
    private final ExternalBackgroundCheck externalBackgroundCheck; // 导入外部系统信息（灰度租户可见）
    private final ExternalInterview externalInterview; // 导入外部系统信息（灰度租户可见）
    private final ExternalInterviewAssessment externalInterviewAssessment; // 导入外部系统信息（灰度租户可见）
    private final Interview interview; // 面试
    private final Job job; // 职位
    private final JobManager jobManager; // job.manager
    private final JobProcess jobProcess; // 流程
    private final JobRequirement jobRequirement; // 招聘需求（灰度租户可见）
    private final JobRequirementSchema jobRequirementSchema; // job_requirement_schema
    private final JobType jobType; // job_type
    private final Note note; // 备注
    private final Offer offer; // Offer
    private final OfferSchema offerSchema; // offer_schema
    private final Questionnaire questionnaire; // 问卷（灰度租户可见）
    private final Referral referral; // 内推
    private final ReferralAccount referralAccount; // referral_account
    private final ReferralWebsiteJobPost referralWebsiteJobPost; // referral_website.job_post
    private final RegistrationSchema registrationSchema; // registration_schema
    private final ResumeSource resumeSource; // 简历来源
    private final Talent talent; // 人才
    private final TalentFolder talentFolder; // talent_folder
    private final TalentObject talentObject; // talent_object

    public V1(Config config) {
        this.application = new Application(config);
        this.applicationInterview = new ApplicationInterview(config);
        this.attachment = new Attachment(config);
        this.ecoAccount = new EcoAccount(config);
        this.ecoAccountCustomField = new EcoAccountCustomField(config);
        this.ecoBackgroundCheck = new EcoBackgroundCheck(config);
        this.ecoBackgroundCheckCustomField = new EcoBackgroundCheckCustomField(config);
        this.ecoBackgroundCheckPackage = new EcoBackgroundCheckPackage(config);
        this.ecoExam = new EcoExam(config);
        this.ecoExamPaper = new EcoExamPaper(config);
        this.ehrImportTask = new EhrImportTask(config);
        this.ehrImportTaskForInternshipOffer = new EhrImportTaskForInternshipOffer(config);
        this.employee = new Employee(config);
        this.evaluation = new Evaluation(config);
        this.externalApplication = new ExternalApplication(config);
        this.externalBackgroundCheck = new ExternalBackgroundCheck(config);
        this.externalInterview = new ExternalInterview(config);
        this.externalInterviewAssessment = new ExternalInterviewAssessment(config);
        this.interview = new Interview(config);
        this.job = new Job(config);
        this.jobManager = new JobManager(config);
        this.jobProcess = new JobProcess(config);
        this.jobRequirement = new JobRequirement(config);
        this.jobRequirementSchema = new JobRequirementSchema(config);
        this.jobType = new JobType(config);
        this.note = new Note(config);
        this.offer = new Offer(config);
        this.offerSchema = new OfferSchema(config);
        this.questionnaire = new Questionnaire(config);
        this.referral = new Referral(config);
        this.referralAccount = new ReferralAccount(config);
        this.referralWebsiteJobPost = new ReferralWebsiteJobPost(config);
        this.registrationSchema = new RegistrationSchema(config);
        this.resumeSource = new ResumeSource(config);
        this.talent = new Talent(config);
        this.talentFolder = new TalentFolder(config);
        this.talentObject = new TalentObject(config);
    }

    public Application application() {
        return application;
    }

    public ApplicationInterview applicationInterview() {
        return applicationInterview;
    }

    public Attachment attachment() {
        return attachment;
    }

    public EcoAccount ecoAccount() {
        return ecoAccount;
    }

    public EcoAccountCustomField ecoAccountCustomField() {
        return ecoAccountCustomField;
    }

    public EcoBackgroundCheck ecoBackgroundCheck() {
        return ecoBackgroundCheck;
    }

    public EcoBackgroundCheckCustomField ecoBackgroundCheckCustomField() {
        return ecoBackgroundCheckCustomField;
    }

    public EcoBackgroundCheckPackage ecoBackgroundCheckPackage() {
        return ecoBackgroundCheckPackage;
    }

    public EcoExam ecoExam() {
        return ecoExam;
    }

    public EcoExamPaper ecoExamPaper() {
        return ecoExamPaper;
    }

    public EhrImportTask ehrImportTask() {
        return ehrImportTask;
    }

    public EhrImportTaskForInternshipOffer ehrImportTaskForInternshipOffer() {
        return ehrImportTaskForInternshipOffer;
    }

    public Employee employee() {
        return employee;
    }

    public Evaluation evaluation() {
        return evaluation;
    }

    public ExternalApplication externalApplication() {
        return externalApplication;
    }

    public ExternalBackgroundCheck externalBackgroundCheck() {
        return externalBackgroundCheck;
    }

    public ExternalInterview externalInterview() {
        return externalInterview;
    }

    public ExternalInterviewAssessment externalInterviewAssessment() {
        return externalInterviewAssessment;
    }

    public Interview interview() {
        return interview;
    }

    public Job job() {
        return job;
    }

    public JobManager jobManager() {
        return jobManager;
    }

    public JobProcess jobProcess() {
        return jobProcess;
    }

    public JobRequirement jobRequirement() {
        return jobRequirement;
    }

    public JobRequirementSchema jobRequirementSchema() {
        return jobRequirementSchema;
    }

    public JobType jobType() {
        return jobType;
    }

    public Note note() {
        return note;
    }

    public Offer offer() {
        return offer;
    }

    public OfferSchema offerSchema() {
        return offerSchema;
    }

    public Questionnaire questionnaire() {
        return questionnaire;
    }

    public Referral referral() {
        return referral;
    }

    public ReferralAccount referralAccount() {
        return referralAccount;
    }

    public ReferralWebsiteJobPost referralWebsiteJobPost() {
        return referralWebsiteJobPost;
    }

    public RegistrationSchema registrationSchema() {
        return registrationSchema;
    }

    public ResumeSource resumeSource() {
        return resumeSource;
    }

    public Talent talent() {
        return talent;
    }

    public TalentFolder talentFolder() {
        return talentFolder;
    }

    public TalentObject talentObject() {
        return talentObject;
    }
}