// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;

import com.google.gson.annotations.SerializedName;

public class Mailgroup {
    /**
     * 邮件组ID
     * <p> 示例值：xxxxxxxxxxxxxxx
     */
    @SerializedName("mailgroup_id")
    private String mailgroupId;
    /**
     * 邮件组地址
     * <p> 示例值：test_mail_group@xxx.xx
     */
    @SerializedName("email")
    private String email;
    /**
     * 邮件组名称
     * <p> 示例值：test mail group
     */
    @SerializedName("name")
    private String name;
    /**
     * 邮件组描述
     * <p> 示例值：mail group for testing
     */
    @SerializedName("description")
    private String description;
    /**
     * 邮件组成员数量
     * <p> 示例值：10
     */
    @SerializedName("direct_members_count")
    private String directMembersCount;
    /**
     * 是否包含外部成员
     * <p> 示例值：true
     */
    @SerializedName("include_external_member")
    private Boolean includeExternalMember;
    /**
     * 是否是全员邮件组
     * <p> 示例值：false
     */
    @SerializedName("include_all_company_member")
    private Boolean includeAllCompanyMember;
    /**
     * 谁可发送邮件到此邮件组
     * <p> 示例值：ALL_INTERNAL_USERS
     */
    @SerializedName("who_can_send_mail")
    private String whoCanSendMail;

    // builder 开始
    public Mailgroup() {
    }

    public Mailgroup(Builder builder) {
        /**
         * 邮件组ID
         * <p> 示例值：xxxxxxxxxxxxxxx
         */
        this.mailgroupId = builder.mailgroupId;
        /**
         * 邮件组地址
         * <p> 示例值：test_mail_group@xxx.xx
         */
        this.email = builder.email;
        /**
         * 邮件组名称
         * <p> 示例值：test mail group
         */
        this.name = builder.name;
        /**
         * 邮件组描述
         * <p> 示例值：mail group for testing
         */
        this.description = builder.description;
        /**
         * 邮件组成员数量
         * <p> 示例值：10
         */
        this.directMembersCount = builder.directMembersCount;
        /**
         * 是否包含外部成员
         * <p> 示例值：true
         */
        this.includeExternalMember = builder.includeExternalMember;
        /**
         * 是否是全员邮件组
         * <p> 示例值：false
         */
        this.includeAllCompanyMember = builder.includeAllCompanyMember;
        /**
         * 谁可发送邮件到此邮件组
         * <p> 示例值：ALL_INTERNAL_USERS
         */
        this.whoCanSendMail = builder.whoCanSendMail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMailgroupId() {
        return this.mailgroupId;
    }

    public void setMailgroupId(String mailgroupId) {
        this.mailgroupId = mailgroupId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDirectMembersCount() {
        return this.directMembersCount;
    }

    public void setDirectMembersCount(String directMembersCount) {
        this.directMembersCount = directMembersCount;
    }

    public Boolean getIncludeExternalMember() {
        return this.includeExternalMember;
    }

    public void setIncludeExternalMember(Boolean includeExternalMember) {
        this.includeExternalMember = includeExternalMember;
    }

    public Boolean getIncludeAllCompanyMember() {
        return this.includeAllCompanyMember;
    }

    public void setIncludeAllCompanyMember(Boolean includeAllCompanyMember) {
        this.includeAllCompanyMember = includeAllCompanyMember;
    }

    public String getWhoCanSendMail() {
        return this.whoCanSendMail;
    }

    public void setWhoCanSendMail(String whoCanSendMail) {
        this.whoCanSendMail = whoCanSendMail;
    }

    public static class Builder {
        /**
         * 邮件组ID
         * <p> 示例值：xxxxxxxxxxxxxxx
         */
        private String mailgroupId;
        /**
         * 邮件组地址
         * <p> 示例值：test_mail_group@xxx.xx
         */
        private String email;
        /**
         * 邮件组名称
         * <p> 示例值：test mail group
         */
        private String name;
        /**
         * 邮件组描述
         * <p> 示例值：mail group for testing
         */
        private String description;
        /**
         * 邮件组成员数量
         * <p> 示例值：10
         */
        private String directMembersCount;
        /**
         * 是否包含外部成员
         * <p> 示例值：true
         */
        private Boolean includeExternalMember;
        /**
         * 是否是全员邮件组
         * <p> 示例值：false
         */
        private Boolean includeAllCompanyMember;
        /**
         * 谁可发送邮件到此邮件组
         * <p> 示例值：ALL_INTERNAL_USERS
         */
        private String whoCanSendMail;

        /**
         * 邮件组ID
         * <p> 示例值：xxxxxxxxxxxxxxx
         *
         * @param mailgroupId
         * @return
         */
        public Builder mailgroupId(String mailgroupId) {
            this.mailgroupId = mailgroupId;
            return this;
        }


        /**
         * 邮件组地址
         * <p> 示例值：test_mail_group@xxx.xx
         *
         * @param email
         * @return
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }


        /**
         * 邮件组名称
         * <p> 示例值：test mail group
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 邮件组描述
         * <p> 示例值：mail group for testing
         *
         * @param description
         * @return
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }


        /**
         * 邮件组成员数量
         * <p> 示例值：10
         *
         * @param directMembersCount
         * @return
         */
        public Builder directMembersCount(String directMembersCount) {
            this.directMembersCount = directMembersCount;
            return this;
        }


        /**
         * 是否包含外部成员
         * <p> 示例值：true
         *
         * @param includeExternalMember
         * @return
         */
        public Builder includeExternalMember(Boolean includeExternalMember) {
            this.includeExternalMember = includeExternalMember;
            return this;
        }


        /**
         * 是否是全员邮件组
         * <p> 示例值：false
         *
         * @param includeAllCompanyMember
         * @return
         */
        public Builder includeAllCompanyMember(Boolean includeAllCompanyMember) {
            this.includeAllCompanyMember = includeAllCompanyMember;
            return this;
        }


        /**
         * 谁可发送邮件到此邮件组
         * <p> 示例值：ALL_INTERNAL_USERS
         *
         * @param whoCanSendMail
         * @return
         */
        public Builder whoCanSendMail(String whoCanSendMail) {
            this.whoCanSendMail = whoCanSendMail;
            return this;
        }

        /**
         * 谁可发送邮件到此邮件组
         * <p> 示例值：ALL_INTERNAL_USERS
         *
         * @param whoCanSendMail {@link com.lark.oapi.service.mail.v1.enums.MailgroupWhoCanSendMailEnum}
         * @return
         */
        public Builder whoCanSendMail(com.lark.oapi.service.mail.v1.enums.MailgroupWhoCanSendMailEnum whoCanSendMail) {
            this.whoCanSendMail = whoCanSendMail.getValue();
            return this;
        }


        public Mailgroup build() {
            return new Mailgroup(this);
        }
    }
}
