// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.google.gson.annotations.SerializedName;

public class UpsertObjectiveKr {
    /**
     * OKR内容
     * <p> 示例值：okr
     */
    @SerializedName("content")
    private String content;
    /**
     * 负责人列表
     * <p> 示例值：
     */
    @SerializedName("mention_list")
    private String[] mentionList;
    /**
     * 得分
     * <p> 示例值：100
     */
    @SerializedName("score")
    private Integer score;
    /**
     * Objective进度状态
     * <p> 示例值：
     */
    @SerializedName("progress_rate")
    private ProgressRate progressRate;
    /**
     * Objective进度列表
     * <p> 示例值：
     */
    @SerializedName("progress_list")
    private ProgressItem[] progressList;
    /**
     * OKR权重
     * <p> 示例值：100
     */
    @SerializedName("weight")
    private Double weight;

    // builder 开始
    public UpsertObjectiveKr() {
    }

    public UpsertObjectiveKr(Builder builder) {
        /**
         * OKR内容
         * <p> 示例值：okr
         */
        this.content = builder.content;
        /**
         * 负责人列表
         * <p> 示例值：
         */
        this.mentionList = builder.mentionList;
        /**
         * 得分
         * <p> 示例值：100
         */
        this.score = builder.score;
        /**
         * Objective进度状态
         * <p> 示例值：
         */
        this.progressRate = builder.progressRate;
        /**
         * Objective进度列表
         * <p> 示例值：
         */
        this.progressList = builder.progressList;
        /**
         * OKR权重
         * <p> 示例值：100
         */
        this.weight = builder.weight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String[] getMentionList() {
        return this.mentionList;
    }

    public void setMentionList(String[] mentionList) {
        this.mentionList = mentionList;
    }

    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public ProgressRate getProgressRate() {
        return this.progressRate;
    }

    public void setProgressRate(ProgressRate progressRate) {
        this.progressRate = progressRate;
    }

    public ProgressItem[] getProgressList() {
        return this.progressList;
    }

    public void setProgressList(ProgressItem[] progressList) {
        this.progressList = progressList;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public static class Builder {
        /**
         * OKR内容
         * <p> 示例值：okr
         */
        private String content;
        /**
         * 负责人列表
         * <p> 示例值：
         */
        private String[] mentionList;
        /**
         * 得分
         * <p> 示例值：100
         */
        private Integer score;
        /**
         * Objective进度状态
         * <p> 示例值：
         */
        private ProgressRate progressRate;
        /**
         * Objective进度列表
         * <p> 示例值：
         */
        private ProgressItem[] progressList;
        /**
         * OKR权重
         * <p> 示例值：100
         */
        private Double weight;

        /**
         * OKR内容
         * <p> 示例值：okr
         *
         * @param content
         * @return
         */
        public Builder content(String content) {
            this.content = content;
            return this;
        }


        /**
         * 负责人列表
         * <p> 示例值：
         *
         * @param mentionList
         * @return
         */
        public Builder mentionList(String[] mentionList) {
            this.mentionList = mentionList;
            return this;
        }


        /**
         * 得分
         * <p> 示例值：100
         *
         * @param score
         * @return
         */
        public Builder score(Integer score) {
            this.score = score;
            return this;
        }


        /**
         * Objective进度状态
         * <p> 示例值：
         *
         * @param progressRate
         * @return
         */
        public Builder progressRate(ProgressRate progressRate) {
            this.progressRate = progressRate;
            return this;
        }


        /**
         * Objective进度列表
         * <p> 示例值：
         *
         * @param progressList
         * @return
         */
        public Builder progressList(ProgressItem[] progressList) {
            this.progressList = progressList;
            return this;
        }


        /**
         * OKR权重
         * <p> 示例值：100
         *
         * @param weight
         * @return
         */
        public Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }


        public UpsertObjectiveKr build() {
            return new UpsertObjectiveKr(this);
        }
    }
}
