// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;

import com.google.gson.annotations.SerializedName;

public class DirectoryItems {
    /**
     * 实体的 id
     * <p> 示例值：134jsi43d3ssi993d435452
     */
    @SerializedName("entity_id")
    private String entityId;
    /**
     * 邮箱地址。当通过 mailbox 查询实体时，返回 mail address，如果没有，则返回空。
     * <p> 示例值：xxx@xxx.xx
     */
    @SerializedName("mail_address")
    private String mailAddress;
    /**
     * 实体的数据驻留地
     * <p> 示例值：SG
     */
    @SerializedName("entity_location")
    private String entityLocation;
    /**
     * 实体创建时间（毫秒级时间戳）
     * <p> 示例值：1615380573411
     */
    @SerializedName("entity_create_time")
    private String entityCreateTime;
    /**
     * 实体的类型
     * <p> 示例值：sheets
     */
    @SerializedName("entity_type")
    private String entityType;

    // builder 开始
    public DirectoryItems() {
    }

    public DirectoryItems(Builder builder) {
        /**
         * 实体的 id
         * <p> 示例值：134jsi43d3ssi993d435452
         */
        this.entityId = builder.entityId;
        /**
         * 邮箱地址。当通过 mailbox 查询实体时，返回 mail address，如果没有，则返回空。
         * <p> 示例值：xxx@xxx.xx
         */
        this.mailAddress = builder.mailAddress;
        /**
         * 实体的数据驻留地
         * <p> 示例值：SG
         */
        this.entityLocation = builder.entityLocation;
        /**
         * 实体创建时间（毫秒级时间戳）
         * <p> 示例值：1615380573411
         */
        this.entityCreateTime = builder.entityCreateTime;
        /**
         * 实体的类型
         * <p> 示例值：sheets
         */
        this.entityType = builder.entityType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getMailAddress() {
        return this.mailAddress;
    }

    public void setMailAddress(String mailAddress) {
        this.mailAddress = mailAddress;
    }

    public String getEntityLocation() {
        return this.entityLocation;
    }

    public void setEntityLocation(String entityLocation) {
        this.entityLocation = entityLocation;
    }

    public String getEntityCreateTime() {
        return this.entityCreateTime;
    }

    public void setEntityCreateTime(String entityCreateTime) {
        this.entityCreateTime = entityCreateTime;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public static class Builder {
        /**
         * 实体的 id
         * <p> 示例值：134jsi43d3ssi993d435452
         */
        private String entityId;
        /**
         * 邮箱地址。当通过 mailbox 查询实体时，返回 mail address，如果没有，则返回空。
         * <p> 示例值：xxx@xxx.xx
         */
        private String mailAddress;
        /**
         * 实体的数据驻留地
         * <p> 示例值：SG
         */
        private String entityLocation;
        /**
         * 实体创建时间（毫秒级时间戳）
         * <p> 示例值：1615380573411
         */
        private String entityCreateTime;
        /**
         * 实体的类型
         * <p> 示例值：sheets
         */
        private String entityType;

        /**
         * 实体的 id
         * <p> 示例值：134jsi43d3ssi993d435452
         *
         * @param entityId
         * @return
         */
        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }


        /**
         * 邮箱地址。当通过 mailbox 查询实体时，返回 mail address，如果没有，则返回空。
         * <p> 示例值：xxx@xxx.xx
         *
         * @param mailAddress
         * @return
         */
        public Builder mailAddress(String mailAddress) {
            this.mailAddress = mailAddress;
            return this;
        }


        /**
         * 实体的数据驻留地
         * <p> 示例值：SG
         *
         * @param entityLocation
         * @return
         */
        public Builder entityLocation(String entityLocation) {
            this.entityLocation = entityLocation;
            return this;
        }

        /**
         * 实体的数据驻留地
         * <p> 示例值：SG
         *
         * @param entityLocation {@link com.lark.oapi.service.security_and_compliance.v1.enums.DirectoryItemsEntityLocationEnum}
         * @return
         */
        public Builder entityLocation(com.lark.oapi.service.security_and_compliance.v1.enums.DirectoryItemsEntityLocationEnum entityLocation) {
            this.entityLocation = entityLocation.getValue();
            return this;
        }


        /**
         * 实体创建时间（毫秒级时间戳）
         * <p> 示例值：1615380573411
         *
         * @param entityCreateTime
         * @return
         */
        public Builder entityCreateTime(String entityCreateTime) {
            this.entityCreateTime = entityCreateTime;
            return this;
        }


        /**
         * 实体的类型
         * <p> 示例值：sheets
         *
         * @param entityType
         * @return
         */
        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        /**
         * 实体的类型
         * <p> 示例值：sheets
         *
         * @param entityType {@link com.lark.oapi.service.security_and_compliance.v1.enums.DirectoryItemsEntityTypeEnum}
         * @return
         */
        public Builder entityType(com.lark.oapi.service.security_and_compliance.v1.enums.DirectoryItemsEntityTypeEnum entityType) {
            this.entityType = entityType.getValue();
            return this;
        }


        public DirectoryItems build() {
            return new DirectoryItems(this);
        }
    }
}
