// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

public class CreateTaskSubtaskReq {
    /**
     * 表示user的ID的类型，支持open_id, user_id, union_id
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 父任务GUID
     * <p> 示例值：e297ddff-06ca-4166-b917-4ce57cd3a7a0
     */
    @Path
    @SerializedName("task_guid")
    private String taskGuid;
    @Body
    private InputTask body;

    // builder 开始
    public CreateTaskSubtaskReq() {
    }

    public CreateTaskSubtaskReq(Builder builder) {
        /**
         * 表示user的ID的类型，支持open_id, user_id, union_id
         * <p> 示例值：open_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 父任务GUID
         * <p> 示例值：e297ddff-06ca-4166-b917-4ce57cd3a7a0
         */
        this.taskGuid = builder.taskGuid;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getTaskGuid() {
        return this.taskGuid;
    }

    public void setTaskGuid(String taskGuid) {
        this.taskGuid = taskGuid;
    }

    public InputTask getInputTask() {
        return this.body;
    }

    public void setInputTask(InputTask body) {
        this.body = body;
    }

    public static class Builder {
        private String userIdType; // 表示user的ID的类型，支持open_id, user_id, union_id
        private String taskGuid; // 父任务GUID
        private InputTask body;

        /**
         * 表示user的ID的类型，支持open_id, user_id, union_id
         * <p> 示例值：open_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 父任务GUID
         * <p> 示例值：e297ddff-06ca-4166-b917-4ce57cd3a7a0
         *
         * @param taskGuid
         * @return
         */
        public Builder taskGuid(String taskGuid) {
            this.taskGuid = taskGuid;
            return this;
        }

        public InputTask getInputTask() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder inputTask(InputTask body) {
            this.body = body;
            return this;
        }

        public CreateTaskSubtaskReq build() {
            return new CreateTaskSubtaskReq(this);
        }
    }
}
