// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.google.gson.annotations.SerializedName;

public class Option {
    /**
     * 选项的GUID
     * <p> 示例值：4216f79b-3fda-4dc6-a0c4-a16022e47152
     */
    @SerializedName("guid")
    private String guid;
    /**
     * 选项名称，不能为空，最大50个字符
     * <p> 示例值：高优
     */
    @SerializedName("name")
    private String name;
    /**
     * 选项的颜色索引值，可以是0～54中的一个数字。如果不填写则会随机选一个。
     * <p> 示例值：1
     */
    @SerializedName("color_index")
    private Integer colorIndex;
    /**
     * 选项是否隐藏。隐藏后的选项在界面不可见，也不可以再通过openapi将字段值设为该选项。
     * <p> 示例值：false
     */
    @SerializedName("is_hidden")
    private Boolean isHidden;

    // builder 开始
    public Option() {
    }

    public Option(Builder builder) {
        /**
         * 选项的GUID
         * <p> 示例值：4216f79b-3fda-4dc6-a0c4-a16022e47152
         */
        this.guid = builder.guid;
        /**
         * 选项名称，不能为空，最大50个字符
         * <p> 示例值：高优
         */
        this.name = builder.name;
        /**
         * 选项的颜色索引值，可以是0～54中的一个数字。如果不填写则会随机选一个。
         * <p> 示例值：1
         */
        this.colorIndex = builder.colorIndex;
        /**
         * 选项是否隐藏。隐藏后的选项在界面不可见，也不可以再通过openapi将字段值设为该选项。
         * <p> 示例值：false
         */
        this.isHidden = builder.isHidden;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(Integer colorIndex) {
        this.colorIndex = colorIndex;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }

    public static class Builder {
        /**
         * 选项的GUID
         * <p> 示例值：4216f79b-3fda-4dc6-a0c4-a16022e47152
         */
        private String guid;
        /**
         * 选项名称，不能为空，最大50个字符
         * <p> 示例值：高优
         */
        private String name;
        /**
         * 选项的颜色索引值，可以是0～54中的一个数字。如果不填写则会随机选一个。
         * <p> 示例值：1
         */
        private Integer colorIndex;
        /**
         * 选项是否隐藏。隐藏后的选项在界面不可见，也不可以再通过openapi将字段值设为该选项。
         * <p> 示例值：false
         */
        private Boolean isHidden;

        /**
         * 选项的GUID
         * <p> 示例值：4216f79b-3fda-4dc6-a0c4-a16022e47152
         *
         * @param guid
         * @return
         */
        public Builder guid(String guid) {
            this.guid = guid;
            return this;
        }


        /**
         * 选项名称，不能为空，最大50个字符
         * <p> 示例值：高优
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 选项的颜色索引值，可以是0～54中的一个数字。如果不填写则会随机选一个。
         * <p> 示例值：1
         *
         * @param colorIndex
         * @return
         */
        public Builder colorIndex(Integer colorIndex) {
            this.colorIndex = colorIndex;
            return this;
        }


        /**
         * 选项是否隐藏。隐藏后的选项在界面不可见，也不可以再通过openapi将字段值设为该选项。
         * <p> 示例值：false
         *
         * @param isHidden
         * @return
         */
        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }


        public Option build() {
            return new Option(this);
        }
    }
}
