// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

public class PatchSectionReq {
    /**
     * 表示user的ID的类型，支持open_id, user_id, union_id
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 要更新的自定义分组GUID
     * <p> 示例值：9842501a-9f47-4ff5-a622-d319eeecb97f
     */
    @Path
    @SerializedName("section_guid")
    private String sectionGuid;
    @Body
    private PatchSectionReqBody body;

    // builder 开始
    public PatchSectionReq() {
    }

    public PatchSectionReq(Builder builder) {
        /**
         * 表示user的ID的类型，支持open_id, user_id, union_id
         * <p> 示例值：open_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 要更新的自定义分组GUID
         * <p> 示例值：9842501a-9f47-4ff5-a622-d319eeecb97f
         */
        this.sectionGuid = builder.sectionGuid;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getSectionGuid() {
        return this.sectionGuid;
    }

    public void setSectionGuid(String sectionGuid) {
        this.sectionGuid = sectionGuid;
    }

    public PatchSectionReqBody getPatchSectionReqBody() {
        return this.body;
    }

    public void setPatchSectionReqBody(PatchSectionReqBody body) {
        this.body = body;
    }

    public static class Builder {
        private String userIdType; // 表示user的ID的类型，支持open_id, user_id, union_id
        private String sectionGuid; // 要更新的自定义分组GUID
        private PatchSectionReqBody body;

        /**
         * 表示user的ID的类型，支持open_id, user_id, union_id
         * <p> 示例值：open_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 要更新的自定义分组GUID
         * <p> 示例值：9842501a-9f47-4ff5-a622-d319eeecb97f
         *
         * @param sectionGuid
         * @return
         */
        public Builder sectionGuid(String sectionGuid) {
            this.sectionGuid = sectionGuid;
            return this;
        }

        public PatchSectionReqBody getPatchSectionReqBody() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder patchSectionReqBody(PatchSectionReqBody body) {
            this.body = body;
            return this;
        }

        public PatchSectionReq build() {
            return new PatchSectionReq(this);
        }
    }
}
