// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;

public class MyAiSipPresent {
    /**
     * 透传数据类型
     * <p> 示例值：card
     */
    @SerializedName("type")
    private String type;
    /**
     * 透传消息体
     * <p> 示例值：{}
     */
    @SerializedName("body")
    private String body;
    /**
     * 在交互卡片的场景下，完成交互，对交互行为做出的响应
     * <p> 示例值：UPDATE
     */
    @SerializedName("operation_type")
    private String operationType;
    /**
     * 是否为交互卡片
     * <p> 示例值：true
     */
    @SerializedName("interactable")
    private Boolean interactable;
    /**
     * 卡片后续链路交互的请求地址
     * <p> 示例值：https://xxxx
     */
    @SerializedName("operation_url")
    private String operationUrl;
    /**
     * 透传数据上屏后，回调业务方的url，支持open API、RPC两种方式
     * <p> 示例值：sd://psm
     */
    @SerializedName("callback_url")
    private String callbackUrl;
    /**
     * 透传数据上屏后，回调给业务方的数据（适用开放平台卡片）
     * <p> 示例值：{}
     */
    @SerializedName("callback_info")
    private String callbackInfo;
    /**
     * 模版信息（适用于模版卡片）
     * <p> 示例值：default
     */
    @SerializedName("card_template_id")
    private String cardTemplateId;
    /**
     * 模版变量信息（适用于模版卡片）
     * <p> 示例值：
     */
    @SerializedName("card_variables")
    private MyAiSipCardVariables cardVariables;

    // builder 开始
    public MyAiSipPresent() {
    }

    public MyAiSipPresent(Builder builder) {
        /**
         * 透传数据类型
         * <p> 示例值：card
         */
        this.type = builder.type;
        /**
         * 透传消息体
         * <p> 示例值：{}
         */
        this.body = builder.body;
        /**
         * 在交互卡片的场景下，完成交互，对交互行为做出的响应
         * <p> 示例值：UPDATE
         */
        this.operationType = builder.operationType;
        /**
         * 是否为交互卡片
         * <p> 示例值：true
         */
        this.interactable = builder.interactable;
        /**
         * 卡片后续链路交互的请求地址
         * <p> 示例值：https://xxxx
         */
        this.operationUrl = builder.operationUrl;
        /**
         * 透传数据上屏后，回调业务方的url，支持open API、RPC两种方式
         * <p> 示例值：sd://psm
         */
        this.callbackUrl = builder.callbackUrl;
        /**
         * 透传数据上屏后，回调给业务方的数据（适用开放平台卡片）
         * <p> 示例值：{}
         */
        this.callbackInfo = builder.callbackInfo;
        /**
         * 模版信息（适用于模版卡片）
         * <p> 示例值：default
         */
        this.cardTemplateId = builder.cardTemplateId;
        /**
         * 模版变量信息（适用于模版卡片）
         * <p> 示例值：
         */
        this.cardVariables = builder.cardVariables;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public Boolean getInteractable() {
        return this.interactable;
    }

    public void setInteractable(Boolean interactable) {
        this.interactable = interactable;
    }

    public String getOperationUrl() {
        return this.operationUrl;
    }

    public void setOperationUrl(String operationUrl) {
        this.operationUrl = operationUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackInfo() {
        return this.callbackInfo;
    }

    public void setCallbackInfo(String callbackInfo) {
        this.callbackInfo = callbackInfo;
    }

    public String getCardTemplateId() {
        return this.cardTemplateId;
    }

    public void setCardTemplateId(String cardTemplateId) {
        this.cardTemplateId = cardTemplateId;
    }

    public MyAiSipCardVariables getCardVariables() {
        return this.cardVariables;
    }

    public void setCardVariables(MyAiSipCardVariables cardVariables) {
        this.cardVariables = cardVariables;
    }

    public static class Builder {
        /**
         * 透传数据类型
         * <p> 示例值：card
         */
        private String type;
        /**
         * 透传消息体
         * <p> 示例值：{}
         */
        private String body;
        /**
         * 在交互卡片的场景下，完成交互，对交互行为做出的响应
         * <p> 示例值：UPDATE
         */
        private String operationType;
        /**
         * 是否为交互卡片
         * <p> 示例值：true
         */
        private Boolean interactable;
        /**
         * 卡片后续链路交互的请求地址
         * <p> 示例值：https://xxxx
         */
        private String operationUrl;
        /**
         * 透传数据上屏后，回调业务方的url，支持open API、RPC两种方式
         * <p> 示例值：sd://psm
         */
        private String callbackUrl;
        /**
         * 透传数据上屏后，回调给业务方的数据（适用开放平台卡片）
         * <p> 示例值：{}
         */
        private String callbackInfo;
        /**
         * 模版信息（适用于模版卡片）
         * <p> 示例值：default
         */
        private String cardTemplateId;
        /**
         * 模版变量信息（适用于模版卡片）
         * <p> 示例值：
         */
        private MyAiSipCardVariables cardVariables;

        /**
         * 透传数据类型
         * <p> 示例值：card
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }


        /**
         * 透传消息体
         * <p> 示例值：{}
         *
         * @param body
         * @return
         */
        public Builder body(String body) {
            this.body = body;
            return this;
        }


        /**
         * 在交互卡片的场景下，完成交互，对交互行为做出的响应
         * <p> 示例值：UPDATE
         *
         * @param operationType
         * @return
         */
        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }


        /**
         * 是否为交互卡片
         * <p> 示例值：true
         *
         * @param interactable
         * @return
         */
        public Builder interactable(Boolean interactable) {
            this.interactable = interactable;
            return this;
        }


        /**
         * 卡片后续链路交互的请求地址
         * <p> 示例值：https://xxxx
         *
         * @param operationUrl
         * @return
         */
        public Builder operationUrl(String operationUrl) {
            this.operationUrl = operationUrl;
            return this;
        }


        /**
         * 透传数据上屏后，回调业务方的url，支持open API、RPC两种方式
         * <p> 示例值：sd://psm
         *
         * @param callbackUrl
         * @return
         */
        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }


        /**
         * 透传数据上屏后，回调给业务方的数据（适用开放平台卡片）
         * <p> 示例值：{}
         *
         * @param callbackInfo
         * @return
         */
        public Builder callbackInfo(String callbackInfo) {
            this.callbackInfo = callbackInfo;
            return this;
        }


        /**
         * 模版信息（适用于模版卡片）
         * <p> 示例值：default
         *
         * @param cardTemplateId
         * @return
         */
        public Builder cardTemplateId(String cardTemplateId) {
            this.cardTemplateId = cardTemplateId;
            return this;
        }


        /**
         * 模版变量信息（适用于模版卡片）
         * <p> 示例值：
         *
         * @param cardVariables
         * @return
         */
        public Builder cardVariables(MyAiSipCardVariables cardVariables) {
            this.cardVariables = cardVariables;
            return this;
        }


        public MyAiSipPresent build() {
            return new MyAiSipPresent(this);
        }
    }
}
