// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.google.gson.annotations.SerializedName;

public class Event {
    /**
     * 事件类型，事件唯一标识
     * <p> 示例值：im.chat.updated_v1
     */
    @SerializedName("event_type")
    private String eventType;
    /**
     * 事件名称
     * <p> 示例值：群配置修改事件
     */
    @SerializedName("event_name")
    private String eventName;
    /**
     * 事件描述
     * <p> 示例值：群聊名称、头像、描述以及群编辑权限、群分享权限等被修改时推送事件
     */
    @SerializedName("event_description")
    private String eventDescription;

    // builder 开始
    public Event() {
    }

    public Event(Builder builder) {
        /**
         * 事件类型，事件唯一标识
         * <p> 示例值：im.chat.updated_v1
         */
        this.eventType = builder.eventType;
        /**
         * 事件名称
         * <p> 示例值：群配置修改事件
         */
        this.eventName = builder.eventName;
        /**
         * 事件描述
         * <p> 示例值：群聊名称、头像、描述以及群编辑权限、群分享权限等被修改时推送事件
         */
        this.eventDescription = builder.eventDescription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    public static class Builder {
        /**
         * 事件类型，事件唯一标识
         * <p> 示例值：im.chat.updated_v1
         */
        private String eventType;
        /**
         * 事件名称
         * <p> 示例值：群配置修改事件
         */
        private String eventName;
        /**
         * 事件描述
         * <p> 示例值：群聊名称、头像、描述以及群编辑权限、群分享权限等被修改时推送事件
         */
        private String eventDescription;

        /**
         * 事件类型，事件唯一标识
         * <p> 示例值：im.chat.updated_v1
         *
         * @param eventType
         * @return
         */
        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }


        /**
         * 事件名称
         * <p> 示例值：群配置修改事件
         *
         * @param eventName
         * @return
         */
        public Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }


        /**
         * 事件描述
         * <p> 示例值：群聊名称、头像、描述以及群编辑权限、群分享权限等被修改时推送事件
         *
         * @param eventDescription
         * @return
         */
        public Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }


        public Event build() {
            return new Event(this);
        }
    }
}
