// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.google.gson.annotations.SerializedName;

public class EventAndCallbackEncryptStrategy {
    /**
     * 加密key, 配置 Encrypt Key 后，开放平台将向请求地址推送加密后的事件
     * <p> 示例值：xE4k2SkQgtbC8jZEviGRshiZrdPqdkRI
     */
    @SerializedName("encryption_key")
    private String encryptionKey;
    /**
     * 开放平台向应用推送的事件中都带有此 Token，应用可以据此 Token 验证推送的事件是否属于该应用。
     * <p> 示例值：lVEjWtBAu6kVIgSLMV3C4f5W2sAAwvqS
     */
    @SerializedName("verification_token")
    private String verificationToken;

    // builder 开始
    public EventAndCallbackEncryptStrategy() {
    }

    public EventAndCallbackEncryptStrategy(Builder builder) {
        /**
         * 加密key, 配置 Encrypt Key 后，开放平台将向请求地址推送加密后的事件
         * <p> 示例值：xE4k2SkQgtbC8jZEviGRshiZrdPqdkRI
         */
        this.encryptionKey = builder.encryptionKey;
        /**
         * 开放平台向应用推送的事件中都带有此 Token，应用可以据此 Token 验证推送的事件是否属于该应用。
         * <p> 示例值：lVEjWtBAu6kVIgSLMV3C4f5W2sAAwvqS
         */
        this.verificationToken = builder.verificationToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getVerificationToken() {
        return this.verificationToken;
    }

    public void setVerificationToken(String verificationToken) {
        this.verificationToken = verificationToken;
    }

    public static class Builder {
        /**
         * 加密key, 配置 Encrypt Key 后，开放平台将向请求地址推送加密后的事件
         * <p> 示例值：xE4k2SkQgtbC8jZEviGRshiZrdPqdkRI
         */
        private String encryptionKey;
        /**
         * 开放平台向应用推送的事件中都带有此 Token，应用可以据此 Token 验证推送的事件是否属于该应用。
         * <p> 示例值：lVEjWtBAu6kVIgSLMV3C4f5W2sAAwvqS
         */
        private String verificationToken;

        /**
         * 加密key, 配置 Encrypt Key 后，开放平台将向请求地址推送加密后的事件
         * <p> 示例值：xE4k2SkQgtbC8jZEviGRshiZrdPqdkRI
         *
         * @param encryptionKey
         * @return
         */
        public Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }


        /**
         * 开放平台向应用推送的事件中都带有此 Token，应用可以据此 Token 验证推送的事件是否属于该应用。
         * <p> 示例值：lVEjWtBAu6kVIgSLMV3C4f5W2sAAwvqS
         *
         * @param verificationToken
         * @return
         */
        public Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }


        public EventAndCallbackEncryptStrategy build() {
            return new EventAndCallbackEncryptStrategy(this);
        }
    }
}
