// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4.model;

import com.google.gson.annotations.SerializedName;

public class MeetingSettings {
    /**
     * 设置会议 owner
     * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
     */
    @SerializedName("owner_id")
    private String ownerId;
    /**
     * 设置入会范围
     * <p> 示例值：
     */
    @SerializedName("join_meeting_permission")
    private String joinMeetingPermission;
    /**
     * 设置会议密码，仅支持 4-9 位数字
     * <p> 示例值：971024
     */
    @SerializedName("password")
    private String password;
    /**
     * 指定主持人
     * <p> 示例值：
     */
    @SerializedName("assign_hosts")
    private String[] assignHosts;
    /**
     * 设置自动录制
     * <p> 示例值：false
     */
    @SerializedName("auto_record")
    private Boolean autoRecord;
    /**
     * 开启等候室
     * <p> 示例值：true
     */
    @SerializedName("open_lobby")
    private Boolean openLobby;
    /**
     * 允许日程参与者发起会议
     * <p> 示例值：true
     */
    @SerializedName("allow_attendees_start")
    private Boolean allowAttendeesStart;

    // builder 开始
    public MeetingSettings() {
    }

    public MeetingSettings(Builder builder) {
        /**
         * 设置会议 owner
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         */
        this.ownerId = builder.ownerId;
        /**
         * 设置入会范围
         * <p> 示例值：
         */
        this.joinMeetingPermission = builder.joinMeetingPermission;
        /**
         * 设置会议密码，仅支持 4-9 位数字
         * <p> 示例值：971024
         */
        this.password = builder.password;
        /**
         * 指定主持人
         * <p> 示例值：
         */
        this.assignHosts = builder.assignHosts;
        /**
         * 设置自动录制
         * <p> 示例值：false
         */
        this.autoRecord = builder.autoRecord;
        /**
         * 开启等候室
         * <p> 示例值：true
         */
        this.openLobby = builder.openLobby;
        /**
         * 允许日程参与者发起会议
         * <p> 示例值：true
         */
        this.allowAttendeesStart = builder.allowAttendeesStart;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getJoinMeetingPermission() {
        return this.joinMeetingPermission;
    }

    public void setJoinMeetingPermission(String joinMeetingPermission) {
        this.joinMeetingPermission = joinMeetingPermission;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getAssignHosts() {
        return this.assignHosts;
    }

    public void setAssignHosts(String[] assignHosts) {
        this.assignHosts = assignHosts;
    }

    public Boolean getAutoRecord() {
        return this.autoRecord;
    }

    public void setAutoRecord(Boolean autoRecord) {
        this.autoRecord = autoRecord;
    }

    public Boolean getOpenLobby() {
        return this.openLobby;
    }

    public void setOpenLobby(Boolean openLobby) {
        this.openLobby = openLobby;
    }

    public Boolean getAllowAttendeesStart() {
        return this.allowAttendeesStart;
    }

    public void setAllowAttendeesStart(Boolean allowAttendeesStart) {
        this.allowAttendeesStart = allowAttendeesStart;
    }

    public static class Builder {
        /**
         * 设置会议 owner
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         */
        private String ownerId;
        /**
         * 设置入会范围
         * <p> 示例值：
         */
        private String joinMeetingPermission;
        /**
         * 设置会议密码，仅支持 4-9 位数字
         * <p> 示例值：971024
         */
        private String password;
        /**
         * 指定主持人
         * <p> 示例值：
         */
        private String[] assignHosts;
        /**
         * 设置自动录制
         * <p> 示例值：false
         */
        private Boolean autoRecord;
        /**
         * 开启等候室
         * <p> 示例值：true
         */
        private Boolean openLobby;
        /**
         * 允许日程参与者发起会议
         * <p> 示例值：true
         */
        private Boolean allowAttendeesStart;

        /**
         * 设置会议 owner
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         *
         * @param ownerId
         * @return
         */
        public Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }


        /**
         * 设置入会范围
         * <p> 示例值：
         *
         * @param joinMeetingPermission
         * @return
         */
        public Builder joinMeetingPermission(String joinMeetingPermission) {
            this.joinMeetingPermission = joinMeetingPermission;
            return this;
        }

        /**
         * 设置入会范围
         * <p> 示例值：
         *
         * @param joinMeetingPermission {@link com.lark.oapi.service.calendar.v4.enums.MeetingSettingsJoinMeetingPermissionTypeEnum}
         * @return
         */
        public Builder joinMeetingPermission(com.lark.oapi.service.calendar.v4.enums.MeetingSettingsJoinMeetingPermissionTypeEnum joinMeetingPermission) {
            this.joinMeetingPermission = joinMeetingPermission.getValue();
            return this;
        }


        /**
         * 设置会议密码，仅支持 4-9 位数字
         * <p> 示例值：971024
         *
         * @param password
         * @return
         */
        public Builder password(String password) {
            this.password = password;
            return this;
        }


        /**
         * 指定主持人
         * <p> 示例值：
         *
         * @param assignHosts
         * @return
         */
        public Builder assignHosts(String[] assignHosts) {
            this.assignHosts = assignHosts;
            return this;
        }


        /**
         * 设置自动录制
         * <p> 示例值：false
         *
         * @param autoRecord
         * @return
         */
        public Builder autoRecord(Boolean autoRecord) {
            this.autoRecord = autoRecord;
            return this;
        }


        /**
         * 开启等候室
         * <p> 示例值：true
         *
         * @param openLobby
         * @return
         */
        public Builder openLobby(Boolean openLobby) {
            this.openLobby = openLobby;
            return this;
        }


        /**
         * 允许日程参与者发起会议
         * <p> 示例值：true
         *
         * @param allowAttendeesStart
         * @return
         */
        public Builder allowAttendeesStart(Boolean allowAttendeesStart) {
            this.allowAttendeesStart = allowAttendeesStart;
            return this;
        }


        public MeetingSettings build() {
            return new MeetingSettings(this);
        }
    }
}
