// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class SortOption {
    /**
     * 排序字段
     * <p> 示例值：wk_id
     */
    @SerializedName("sort_field")
    private String sortField;
    /**
     * 排序顺序
     * <p> 示例值：0
     */
    @SerializedName("sort_order")
    private Integer sortOrder;
    /**
     * 0=中文关键字;1=英文关键字;2=拼音
     * <p> 示例值：1
     */
    @SerializedName("sort_i18n")
    private Integer sortI18n;
    /**
     * 按某个字段的层级深度排序
     * <p> 示例值：false
     */
    @SerializedName("sort_by_strand_length")
    private Boolean sortByStrandLength;
    /**
     * 是否按照拼音排序
     * <p> 示例值：false
     */
    @SerializedName("sort_by_pinyin")
    private Boolean sortByPinyin;
    /**
     * 是否按照枚举类型 value_order 排序
     * <p> 示例值：false
     */
    @SerializedName("sort_by_enum_value_order")
    private Boolean sortByEnumValueOrder;

    // builder 开始
    public SortOption() {
    }

    public SortOption(Builder builder) {
        /**
         * 排序字段
         * <p> 示例值：wk_id
         */
        this.sortField = builder.sortField;
        /**
         * 排序顺序
         * <p> 示例值：0
         */
        this.sortOrder = builder.sortOrder;
        /**
         * 0=中文关键字;1=英文关键字;2=拼音
         * <p> 示例值：1
         */
        this.sortI18n = builder.sortI18n;
        /**
         * 按某个字段的层级深度排序
         * <p> 示例值：false
         */
        this.sortByStrandLength = builder.sortByStrandLength;
        /**
         * 是否按照拼音排序
         * <p> 示例值：false
         */
        this.sortByPinyin = builder.sortByPinyin;
        /**
         * 是否按照枚举类型 value_order 排序
         * <p> 示例值：false
         */
        this.sortByEnumValueOrder = builder.sortByEnumValueOrder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getSortI18n() {
        return this.sortI18n;
    }

    public void setSortI18n(Integer sortI18n) {
        this.sortI18n = sortI18n;
    }

    public Boolean getSortByStrandLength() {
        return this.sortByStrandLength;
    }

    public void setSortByStrandLength(Boolean sortByStrandLength) {
        this.sortByStrandLength = sortByStrandLength;
    }

    public Boolean getSortByPinyin() {
        return this.sortByPinyin;
    }

    public void setSortByPinyin(Boolean sortByPinyin) {
        this.sortByPinyin = sortByPinyin;
    }

    public Boolean getSortByEnumValueOrder() {
        return this.sortByEnumValueOrder;
    }

    public void setSortByEnumValueOrder(Boolean sortByEnumValueOrder) {
        this.sortByEnumValueOrder = sortByEnumValueOrder;
    }

    public static class Builder {
        /**
         * 排序字段
         * <p> 示例值：wk_id
         */
        private String sortField;
        /**
         * 排序顺序
         * <p> 示例值：0
         */
        private Integer sortOrder;
        /**
         * 0=中文关键字;1=英文关键字;2=拼音
         * <p> 示例值：1
         */
        private Integer sortI18n;
        /**
         * 按某个字段的层级深度排序
         * <p> 示例值：false
         */
        private Boolean sortByStrandLength;
        /**
         * 是否按照拼音排序
         * <p> 示例值：false
         */
        private Boolean sortByPinyin;
        /**
         * 是否按照枚举类型 value_order 排序
         * <p> 示例值：false
         */
        private Boolean sortByEnumValueOrder;

        /**
         * 排序字段
         * <p> 示例值：wk_id
         *
         * @param sortField
         * @return
         */
        public Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }


        /**
         * 排序顺序
         * <p> 示例值：0
         *
         * @param sortOrder
         * @return
         */
        public Builder sortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /**
         * 排序顺序
         * <p> 示例值：0
         *
         * @param sortOrder {@link com.lark.oapi.service.corehr.v1.enums.SortOptionSortOrderEnum}
         * @return
         */
        public Builder sortOrder(com.lark.oapi.service.corehr.v1.enums.SortOptionSortOrderEnum sortOrder) {
            this.sortOrder = sortOrder.getValue();
            return this;
        }


        /**
         * 0=中文关键字;1=英文关键字;2=拼音
         * <p> 示例值：1
         *
         * @param sortI18n
         * @return
         */
        public Builder sortI18n(Integer sortI18n) {
            this.sortI18n = sortI18n;
            return this;
        }

        /**
         * 0=中文关键字;1=英文关键字;2=拼音
         * <p> 示例值：1
         *
         * @param sortI18n {@link com.lark.oapi.service.corehr.v1.enums.SortOptionSortI18NEnum}
         * @return
         */
        public Builder sortI18n(com.lark.oapi.service.corehr.v1.enums.SortOptionSortI18NEnum sortI18n) {
            this.sortI18n = sortI18n.getValue();
            return this;
        }


        /**
         * 按某个字段的层级深度排序
         * <p> 示例值：false
         *
         * @param sortByStrandLength
         * @return
         */
        public Builder sortByStrandLength(Boolean sortByStrandLength) {
            this.sortByStrandLength = sortByStrandLength;
            return this;
        }


        /**
         * 是否按照拼音排序
         * <p> 示例值：false
         *
         * @param sortByPinyin
         * @return
         */
        public Builder sortByPinyin(Boolean sortByPinyin) {
            this.sortByPinyin = sortByPinyin;
            return this;
        }


        /**
         * 是否按照枚举类型 value_order 排序
         * <p> 示例值：false
         *
         * @param sortByEnumValueOrder
         * @return
         */
        public Builder sortByEnumValueOrder(Boolean sortByEnumValueOrder) {
            this.sortByEnumValueOrder = sortByEnumValueOrder;
            return this;
        }


        public SortOption build() {
            return new SortOption(this);
        }
    }
}
