// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.google.gson.annotations.SerializedName;

public class DepartmentTimeline {
    /**
     * 部门 ID
     * <p> 示例值：4719456877659520852
     */
    @SerializedName("id")
    private String id;
    /**
     * 部门名称
     * <p> 示例值：
     */
    @SerializedName("names")
    private I18n[] names;
    /**
     * 上级部门 ID
     * <p> 示例值：4719456877659520111
     */
    @SerializedName("parent_department_id")
    private String parentDepartmentId;
    /**
     * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
     * <p> 示例值：6893013238632416777
     */
    @SerializedName("manager")
    private String manager;
    /**
     * 编码
     * <p> 示例值：D00000456
     */
    @SerializedName("code")
    private String code;
    /**
     * 生效日期
     * <p> 示例值：2020-05-01
     */
    @SerializedName("effective_date")
    private String effectiveDate;
    /**
     * 是否启用
     * <p> 示例值：true
     */
    @SerializedName("active")
    private Boolean active;
    /**
     * 描述
     * <p> 示例值：
     */
    @SerializedName("descriptions")
    private I18n[] descriptions;

    // builder 开始
    public DepartmentTimeline() {
    }

    public DepartmentTimeline(Builder builder) {
        /**
         * 部门 ID
         * <p> 示例值：4719456877659520852
         */
        this.id = builder.id;
        /**
         * 部门名称
         * <p> 示例值：
         */
        this.names = builder.names;
        /**
         * 上级部门 ID
         * <p> 示例值：4719456877659520111
         */
        this.parentDepartmentId = builder.parentDepartmentId;
        /**
         * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
         * <p> 示例值：6893013238632416777
         */
        this.manager = builder.manager;
        /**
         * 编码
         * <p> 示例值：D00000456
         */
        this.code = builder.code;
        /**
         * 生效日期
         * <p> 示例值：2020-05-01
         */
        this.effectiveDate = builder.effectiveDate;
        /**
         * 是否启用
         * <p> 示例值：true
         */
        this.active = builder.active;
        /**
         * 描述
         * <p> 示例值：
         */
        this.descriptions = builder.descriptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public I18n[] getNames() {
        return this.names;
    }

    public void setNames(I18n[] names) {
        this.names = names;
    }

    public String getParentDepartmentId() {
        return this.parentDepartmentId;
    }

    public void setParentDepartmentId(String parentDepartmentId) {
        this.parentDepartmentId = parentDepartmentId;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public I18n[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(I18n[] descriptions) {
        this.descriptions = descriptions;
    }

    public static class Builder {
        /**
         * 部门 ID
         * <p> 示例值：4719456877659520852
         */
        private String id;
        /**
         * 部门名称
         * <p> 示例值：
         */
        private I18n[] names;
        /**
         * 上级部门 ID
         * <p> 示例值：4719456877659520111
         */
        private String parentDepartmentId;
        /**
         * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
         * <p> 示例值：6893013238632416777
         */
        private String manager;
        /**
         * 编码
         * <p> 示例值：D00000456
         */
        private String code;
        /**
         * 生效日期
         * <p> 示例值：2020-05-01
         */
        private String effectiveDate;
        /**
         * 是否启用
         * <p> 示例值：true
         */
        private Boolean active;
        /**
         * 描述
         * <p> 示例值：
         */
        private I18n[] descriptions;

        /**
         * 部门 ID
         * <p> 示例值：4719456877659520852
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 部门名称
         * <p> 示例值：
         *
         * @param names
         * @return
         */
        public Builder names(I18n[] names) {
            this.names = names;
            return this;
        }


        /**
         * 上级部门 ID
         * <p> 示例值：4719456877659520111
         *
         * @param parentDepartmentId
         * @return
         */
        public Builder parentDepartmentId(String parentDepartmentId) {
            this.parentDepartmentId = parentDepartmentId;
            return this;
        }


        /**
         * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
         * <p> 示例值：6893013238632416777
         *
         * @param manager
         * @return
         */
        public Builder manager(String manager) {
            this.manager = manager;
            return this;
        }


        /**
         * 编码
         * <p> 示例值：D00000456
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 生效日期
         * <p> 示例值：2020-05-01
         *
         * @param effectiveDate
         * @return
         */
        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }


        /**
         * 是否启用
         * <p> 示例值：true
         *
         * @param active
         * @return
         */
        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }


        /**
         * 描述
         * <p> 示例值：
         *
         * @param descriptions
         * @return
         */
        public Builder descriptions(I18n[] descriptions) {
            this.descriptions = descriptions;
            return this;
        }


        public DepartmentTimeline build() {
            return new DepartmentTimeline(this);
        }
    }
}
