// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.google.gson.annotations.SerializedName;

public class PrehireUpdate {
    /**
     * 更新个人（person）信息
     * <p> 示例值：
     */
    @SerializedName("basic_info_update")
    private BasicInfoUpdate basicInfoUpdate;
    /**
     * 更新待入职（prehire）信息
     * <p> 示例值：
     */
    @SerializedName("offer_info_update")
    private OfferInfoUpdate offerInfoUpdate;
    /**
     * 指定需要更新的系统字段，只支持最多下钻一层，格式如下：; - basic_info_update字段：basic_info_update.name（对name整体进行覆盖更新）；basic_info_update.emails（对邮箱整体进行更新）; - offer_info_update字段：offer_info_update.onboarding_method; - 招聘ID：ats_application_id
     * <p> 示例值：\["basic_info_update.names","offer_info_update.onboarding_method"\]
     */
    @SerializedName("standard_update_fields")
    private String[] standardUpdateFields;
    /**
     * 指定需要更新的PreHire对象上的自定义字段，格式如下：; - custom_field1__c
     * <p> 示例值：\["custom_field1__c","custom_field2__c"\]
     */
    @SerializedName("custom_update_fields")
    private String[] customUpdateFields;

    // builder 开始
    public PrehireUpdate() {
    }

    public PrehireUpdate(Builder builder) {
        /**
         * 更新个人（person）信息
         * <p> 示例值：
         */
        this.basicInfoUpdate = builder.basicInfoUpdate;
        /**
         * 更新待入职（prehire）信息
         * <p> 示例值：
         */
        this.offerInfoUpdate = builder.offerInfoUpdate;
        /**
         * 指定需要更新的系统字段，只支持最多下钻一层，格式如下：; - basic_info_update字段：basic_info_update.name（对name整体进行覆盖更新）；basic_info_update.emails（对邮箱整体进行更新）; - offer_info_update字段：offer_info_update.onboarding_method; - 招聘ID：ats_application_id
         * <p> 示例值：\["basic_info_update.names","offer_info_update.onboarding_method"\]
         */
        this.standardUpdateFields = builder.standardUpdateFields;
        /**
         * 指定需要更新的PreHire对象上的自定义字段，格式如下：; - custom_field1__c
         * <p> 示例值：\["custom_field1__c","custom_field2__c"\]
         */
        this.customUpdateFields = builder.customUpdateFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public BasicInfoUpdate getBasicInfoUpdate() {
        return this.basicInfoUpdate;
    }

    public void setBasicInfoUpdate(BasicInfoUpdate basicInfoUpdate) {
        this.basicInfoUpdate = basicInfoUpdate;
    }

    public OfferInfoUpdate getOfferInfoUpdate() {
        return this.offerInfoUpdate;
    }

    public void setOfferInfoUpdate(OfferInfoUpdate offerInfoUpdate) {
        this.offerInfoUpdate = offerInfoUpdate;
    }

    public String[] getStandardUpdateFields() {
        return this.standardUpdateFields;
    }

    public void setStandardUpdateFields(String[] standardUpdateFields) {
        this.standardUpdateFields = standardUpdateFields;
    }

    public String[] getCustomUpdateFields() {
        return this.customUpdateFields;
    }

    public void setCustomUpdateFields(String[] customUpdateFields) {
        this.customUpdateFields = customUpdateFields;
    }

    public static class Builder {
        /**
         * 更新个人（person）信息
         * <p> 示例值：
         */
        private BasicInfoUpdate basicInfoUpdate;
        /**
         * 更新待入职（prehire）信息
         * <p> 示例值：
         */
        private OfferInfoUpdate offerInfoUpdate;
        /**
         * 指定需要更新的系统字段，只支持最多下钻一层，格式如下：; - basic_info_update字段：basic_info_update.name（对name整体进行覆盖更新）；basic_info_update.emails（对邮箱整体进行更新）; - offer_info_update字段：offer_info_update.onboarding_method; - 招聘ID：ats_application_id
         * <p> 示例值：\["basic_info_update.names","offer_info_update.onboarding_method"\]
         */
        private String[] standardUpdateFields;
        /**
         * 指定需要更新的PreHire对象上的自定义字段，格式如下：; - custom_field1__c
         * <p> 示例值：\["custom_field1__c","custom_field2__c"\]
         */
        private String[] customUpdateFields;

        /**
         * 更新个人（person）信息
         * <p> 示例值：
         *
         * @param basicInfoUpdate
         * @return
         */
        public Builder basicInfoUpdate(BasicInfoUpdate basicInfoUpdate) {
            this.basicInfoUpdate = basicInfoUpdate;
            return this;
        }


        /**
         * 更新待入职（prehire）信息
         * <p> 示例值：
         *
         * @param offerInfoUpdate
         * @return
         */
        public Builder offerInfoUpdate(OfferInfoUpdate offerInfoUpdate) {
            this.offerInfoUpdate = offerInfoUpdate;
            return this;
        }


        /**
         * 指定需要更新的系统字段，只支持最多下钻一层，格式如下：; - basic_info_update字段：basic_info_update.name（对name整体进行覆盖更新）；basic_info_update.emails（对邮箱整体进行更新）; - offer_info_update字段：offer_info_update.onboarding_method; - 招聘ID：ats_application_id
         * <p> 示例值：\["basic_info_update.names","offer_info_update.onboarding_method"\]
         *
         * @param standardUpdateFields
         * @return
         */
        public Builder standardUpdateFields(String[] standardUpdateFields) {
            this.standardUpdateFields = standardUpdateFields;
            return this;
        }


        /**
         * 指定需要更新的PreHire对象上的自定义字段，格式如下：; - custom_field1__c
         * <p> 示例值：\["custom_field1__c","custom_field2__c"\]
         *
         * @param customUpdateFields
         * @return
         */
        public Builder customUpdateFields(String[] customUpdateFields) {
            this.customUpdateFields = customUpdateFields;
            return this;
        }


        public PrehireUpdate build() {
            return new PrehireUpdate(this);
        }
    }
}
