// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.google.gson.annotations.SerializedName;

public class ProcessLink {
    /**
     * web端单据详情页地址
     * <p> 示例值：http://xxxx.com/xxx/xxx?a=b
     */
    @SerializedName("web_link")
    private String webLink;
    /**
     * 飞书pc端单据详情页地址
     * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
     */
    @SerializedName("pc_link")
    private String pcLink;
    /**
     * 飞书移动端单据详情页地址
     * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
     */
    @SerializedName("mobile_link")
    private String mobileLink;

    // builder 开始
    public ProcessLink() {
    }

    public ProcessLink(Builder builder) {
        /**
         * web端单据详情页地址
         * <p> 示例值：http://xxxx.com/xxx/xxx?a=b
         */
        this.webLink = builder.webLink;
        /**
         * 飞书pc端单据详情页地址
         * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
         */
        this.pcLink = builder.pcLink;
        /**
         * 飞书移动端单据详情页地址
         * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
         */
        this.mobileLink = builder.mobileLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getWebLink() {
        return this.webLink;
    }

    public void setWebLink(String webLink) {
        this.webLink = webLink;
    }

    public String getPcLink() {
        return this.pcLink;
    }

    public void setPcLink(String pcLink) {
        this.pcLink = pcLink;
    }

    public String getMobileLink() {
        return this.mobileLink;
    }

    public void setMobileLink(String mobileLink) {
        this.mobileLink = mobileLink;
    }

    public static class Builder {
        /**
         * web端单据详情页地址
         * <p> 示例值：http://xxxx.com/xxx/xxx?a=b
         */
        private String webLink;
        /**
         * 飞书pc端单据详情页地址
         * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
         */
        private String pcLink;
        /**
         * 飞书移动端单据详情页地址
         * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
         */
        private String mobileLink;

        /**
         * web端单据详情页地址
         * <p> 示例值：http://xxxx.com/xxx/xxx?a=b
         *
         * @param webLink
         * @return
         */
        public Builder webLink(String webLink) {
            this.webLink = webLink;
            return this;
        }


        /**
         * 飞书pc端单据详情页地址
         * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
         *
         * @param pcLink
         * @return
         */
        public Builder pcLink(String pcLink) {
            this.pcLink = pcLink;
            return this;
        }


        /**
         * 飞书移动端单据详情页地址
         * <p> 示例值：https://applink.feishu.cn/client/mini_program/open?appId=xxx
         *
         * @param mobileLink
         * @return
         */
        public Builder mobileLink(String mobileLink) {
            this.mobileLink = mobileLink;
            return this;
        }


        public ProcessLink build() {
            return new ProcessLink(this);
        }
    }
}
