// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.google.gson.annotations.SerializedName;

public class ProfileSettingEducation {
    /**
     * 学校
     * <p> 示例值：北京大学
     */
    @SerializedName("school")
    private String school;
    /**
     * "学校, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""school_name"""
     * <p> 示例值：school-177
     */
    @SerializedName("school_enum")
    private String schoolEnum;
    /**
     * 开始日期
     * <p> 示例值：2011-09-01
     */
    @SerializedName("start_date")
    private String startDate;
    /**
     * 结束日期
     * <p> 示例值：2015-06-30
     */
    @SerializedName("end_date")
    private String endDate;
    /**
     * 学历, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "level_of_education"
     * <p> 示例值：masters_degree
     */
    @SerializedName("level_of_education")
    private String levelOfEducation;
    /**
     * 专业
     * <p> 示例值：软件工程
     */
    @SerializedName("field_of_study")
    private String fieldOfStudy;
    /**
     * 学位,枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "degree"
     * <p> 示例值：bachelors_degree
     */
    @SerializedName("degree")
    private String degree;
    /**
     * "专业，枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""field_of_study_name"""
     * <p> 示例值：field_of_study-2
     */
    @SerializedName("field_of_study_enum")
    private String fieldOfStudyEnum;
    /**
     * 自定义字段
     * <p> 示例值：
     */
    @SerializedName("custom_fields")
    private ProfileSettingCustomField[] customFields;

    // builder 开始
    public ProfileSettingEducation() {
    }

    public ProfileSettingEducation(Builder builder) {
        /**
         * 学校
         * <p> 示例值：北京大学
         */
        this.school = builder.school;
        /**
         * "学校, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""school_name"""
         * <p> 示例值：school-177
         */
        this.schoolEnum = builder.schoolEnum;
        /**
         * 开始日期
         * <p> 示例值：2011-09-01
         */
        this.startDate = builder.startDate;
        /**
         * 结束日期
         * <p> 示例值：2015-06-30
         */
        this.endDate = builder.endDate;
        /**
         * 学历, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "level_of_education"
         * <p> 示例值：masters_degree
         */
        this.levelOfEducation = builder.levelOfEducation;
        /**
         * 专业
         * <p> 示例值：软件工程
         */
        this.fieldOfStudy = builder.fieldOfStudy;
        /**
         * 学位,枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "degree"
         * <p> 示例值：bachelors_degree
         */
        this.degree = builder.degree;
        /**
         * "专业，枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""field_of_study_name"""
         * <p> 示例值：field_of_study-2
         */
        this.fieldOfStudyEnum = builder.fieldOfStudyEnum;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        this.customFields = builder.customFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSchool() {
        return this.school;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    public String getSchoolEnum() {
        return this.schoolEnum;
    }

    public void setSchoolEnum(String schoolEnum) {
        this.schoolEnum = schoolEnum;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getLevelOfEducation() {
        return this.levelOfEducation;
    }

    public void setLevelOfEducation(String levelOfEducation) {
        this.levelOfEducation = levelOfEducation;
    }

    public String getFieldOfStudy() {
        return this.fieldOfStudy;
    }

    public void setFieldOfStudy(String fieldOfStudy) {
        this.fieldOfStudy = fieldOfStudy;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public String getFieldOfStudyEnum() {
        return this.fieldOfStudyEnum;
    }

    public void setFieldOfStudyEnum(String fieldOfStudyEnum) {
        this.fieldOfStudyEnum = fieldOfStudyEnum;
    }

    public ProfileSettingCustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ProfileSettingCustomField[] customFields) {
        this.customFields = customFields;
    }

    public static class Builder {
        /**
         * 学校
         * <p> 示例值：北京大学
         */
        private String school;
        /**
         * "学校, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""school_name"""
         * <p> 示例值：school-177
         */
        private String schoolEnum;
        /**
         * 开始日期
         * <p> 示例值：2011-09-01
         */
        private String startDate;
        /**
         * 结束日期
         * <p> 示例值：2015-06-30
         */
        private String endDate;
        /**
         * 学历, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "level_of_education"
         * <p> 示例值：masters_degree
         */
        private String levelOfEducation;
        /**
         * 专业
         * <p> 示例值：软件工程
         */
        private String fieldOfStudy;
        /**
         * 学位,枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "degree"
         * <p> 示例值：bachelors_degree
         */
        private String degree;
        /**
         * "专业，枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""field_of_study_name"""
         * <p> 示例值：field_of_study-2
         */
        private String fieldOfStudyEnum;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        private ProfileSettingCustomField[] customFields;

        /**
         * 学校
         * <p> 示例值：北京大学
         *
         * @param school
         * @return
         */
        public Builder school(String school) {
            this.school = school;
            return this;
        }


        /**
         * "学校, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""school_name"""
         * <p> 示例值：school-177
         *
         * @param schoolEnum
         * @return
         */
        public Builder schoolEnum(String schoolEnum) {
            this.schoolEnum = schoolEnum;
            return this;
        }


        /**
         * 开始日期
         * <p> 示例值：2011-09-01
         *
         * @param startDate
         * @return
         */
        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }


        /**
         * 结束日期
         * <p> 示例值：2015-06-30
         *
         * @param endDate
         * @return
         */
        public Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }


        /**
         * 学历, 枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "level_of_education"
         * <p> 示例值：masters_degree
         *
         * @param levelOfEducation
         * @return
         */
        public Builder levelOfEducation(String levelOfEducation) {
            this.levelOfEducation = levelOfEducation;
            return this;
        }


        /**
         * 专业
         * <p> 示例值：软件工程
         *
         * @param fieldOfStudy
         * @return
         */
        public Builder fieldOfStudy(String fieldOfStudy) {
            this.fieldOfStudy = fieldOfStudy;
            return this;
        }


        /**
         * 学位,枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = "education" custom_api_name = "degree"
         * <p> 示例值：bachelors_degree
         *
         * @param degree
         * @return
         */
        public Builder degree(String degree) {
            this.degree = degree;
            return this;
        }


        /**
         * "专业，枚举值。 可选项可通过【获取字段详情】接口查询，查询参数如下： object_api_name = ""education"" custom_api_name = ""field_of_study_name"""
         * <p> 示例值：field_of_study-2
         *
         * @param fieldOfStudyEnum
         * @return
         */
        public Builder fieldOfStudyEnum(String fieldOfStudyEnum) {
            this.fieldOfStudyEnum = fieldOfStudyEnum;
            return this;
        }


        /**
         * 自定义字段
         * <p> 示例值：
         *
         * @param customFields
         * @return
         */
        public Builder customFields(ProfileSettingCustomField[] customFields) {
            this.customFields = customFields;
            return this;
        }


        public ProfileSettingEducation build() {
            return new ProfileSettingEducation(this);
        }
    }
}
