// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.document_ai.v1.model;

import com.google.gson.annotations.SerializedName;

public class FieldExtractionContractReqBody {
    /**
     * 合同字段解析的源文件，当前只支持pdf, doc, docx三种类型的文件
     * <p> 示例值：
     */
    @SerializedName("file")
    private java.io.File file;
    /**
     * pdf页数限制，太长会导致latency增加，最大允许100页
     * <p> 示例值：15
     */
    @SerializedName("pdf_page_limit")
    private Integer pdfPageLimit;
    /**
     * ocr 参数，当前支持force, pdf, unused三种格式
     * <p> 示例值：auto
     */
    @SerializedName("ocr_mode")
    private String ocrMode;

    // builder 开始
    public FieldExtractionContractReqBody() {
    }

    public FieldExtractionContractReqBody(Builder builder) {
        /**
         * 合同字段解析的源文件，当前只支持pdf, doc, docx三种类型的文件
         * <p> 示例值：
         */
        this.file = builder.file;
        /**
         * pdf页数限制，太长会导致latency增加，最大允许100页
         * <p> 示例值：15
         */
        this.pdfPageLimit = builder.pdfPageLimit;
        /**
         * ocr 参数，当前支持force, pdf, unused三种格式
         * <p> 示例值：auto
         */
        this.ocrMode = builder.ocrMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public java.io.File getFile() {
        return this.file;
    }

    public void setFile(java.io.File file) {
        this.file = file;
    }

    public Integer getPdfPageLimit() {
        return this.pdfPageLimit;
    }

    public void setPdfPageLimit(Integer pdfPageLimit) {
        this.pdfPageLimit = pdfPageLimit;
    }

    public String getOcrMode() {
        return this.ocrMode;
    }

    public void setOcrMode(String ocrMode) {
        this.ocrMode = ocrMode;
    }

    public static class Builder {
        /**
         * 合同字段解析的源文件，当前只支持pdf, doc, docx三种类型的文件
         * <p> 示例值：
         */
        private java.io.File file;
        /**
         * pdf页数限制，太长会导致latency增加，最大允许100页
         * <p> 示例值：15
         */
        private Integer pdfPageLimit;
        /**
         * ocr 参数，当前支持force, pdf, unused三种格式
         * <p> 示例值：auto
         */
        private String ocrMode;

        /**
         * 合同字段解析的源文件，当前只支持pdf, doc, docx三种类型的文件
         * <p> 示例值：
         *
         * @param file
         * @return
         */
        public Builder file(java.io.File file) {
            this.file = file;
            return this;
        }


        /**
         * pdf页数限制，太长会导致latency增加，最大允许100页
         * <p> 示例值：15
         *
         * @param pdfPageLimit
         * @return
         */
        public Builder pdfPageLimit(Integer pdfPageLimit) {
            this.pdfPageLimit = pdfPageLimit;
            return this;
        }


        /**
         * ocr 参数，当前支持force, pdf, unused三种格式
         * <p> 示例值：auto
         *
         * @param ocrMode
         * @return
         */
        public Builder ocrMode(String ocrMode) {
            this.ocrMode = ocrMode;
            return this;
        }

        /**
         * ocr 参数，当前支持force, pdf, unused三种格式
         * <p> 示例值：auto
         *
         * @param ocrMode {@link com.lark.oapi.service.document_ai.v1.enums.FieldExtractionContractOcrModeEnum}
         * @return
         */
        public Builder ocrMode(com.lark.oapi.service.document_ai.v1.enums.FieldExtractionContractOcrModeEnum ocrMode) {
            this.ocrMode = ocrMode.getValue();
            return this;
        }


        public FieldExtractionContractReqBody build() {
            return new FieldExtractionContractReqBody(this);
        }
    }
}
