// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v2.model;

import com.google.gson.annotations.SerializedName;

public class ChatPin {
    /**
     * 置顶ID
     * <p> 示例值：7262656565168242692
     */
    @SerializedName("chat_pin_id")
    private String chatPinId;
    /**
     * 群ID
     * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
     */
    @SerializedName("chat_id")
    private String chatId;
    /**
     * 置顶类型
     * <p> 示例值：message_pin
     */
    @SerializedName("chat_pin_type")
    private String chatPinType;
    /**
     * 置顶创建时间，毫秒级别
     * <p> 示例值：1694519103000
     */
    @SerializedName("create_time")
    private String createTime;
    /**
     * 创建置顶的操作者ID
     * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
     */
    @SerializedName("chatter_id")
    private String chatterId;
    /**
     * 该置顶是否固定在置顶列表的最前面
     * <p> 示例值：false
     */
    @SerializedName("is_fixed")
    private Boolean isFixed;
    /**
     * 固定置顶到置顶列表前面的操作者ID
     * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
     */
    @SerializedName("operate_fix_chatter_id")
    private String operateFixChatterId;
    /**
     * 消息置顶数据
     * <p> 示例值：
     */
    @SerializedName("message_pin_data")
    private MessagePin messagePinData;
    /**
     * url类型置顶数据
     * <p> 示例值：
     */
    @SerializedName("url_pin_data")
    private UrlPin urlPinData;

    // builder 开始
    public ChatPin() {
    }

    public ChatPin(Builder builder) {
        /**
         * 置顶ID
         * <p> 示例值：7262656565168242692
         */
        this.chatPinId = builder.chatPinId;
        /**
         * 群ID
         * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
         */
        this.chatId = builder.chatId;
        /**
         * 置顶类型
         * <p> 示例值：message_pin
         */
        this.chatPinType = builder.chatPinType;
        /**
         * 置顶创建时间，毫秒级别
         * <p> 示例值：1694519103000
         */
        this.createTime = builder.createTime;
        /**
         * 创建置顶的操作者ID
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         */
        this.chatterId = builder.chatterId;
        /**
         * 该置顶是否固定在置顶列表的最前面
         * <p> 示例值：false
         */
        this.isFixed = builder.isFixed;
        /**
         * 固定置顶到置顶列表前面的操作者ID
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         */
        this.operateFixChatterId = builder.operateFixChatterId;
        /**
         * 消息置顶数据
         * <p> 示例值：
         */
        this.messagePinData = builder.messagePinData;
        /**
         * url类型置顶数据
         * <p> 示例值：
         */
        this.urlPinData = builder.urlPinData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getChatPinId() {
        return this.chatPinId;
    }

    public void setChatPinId(String chatPinId) {
        this.chatPinId = chatPinId;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getChatPinType() {
        return this.chatPinType;
    }

    public void setChatPinType(String chatPinType) {
        this.chatPinType = chatPinType;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getChatterId() {
        return this.chatterId;
    }

    public void setChatterId(String chatterId) {
        this.chatterId = chatterId;
    }

    public Boolean getIsFixed() {
        return this.isFixed;
    }

    public void setIsFixed(Boolean isFixed) {
        this.isFixed = isFixed;
    }

    public String getOperateFixChatterId() {
        return this.operateFixChatterId;
    }

    public void setOperateFixChatterId(String operateFixChatterId) {
        this.operateFixChatterId = operateFixChatterId;
    }

    public MessagePin getMessagePinData() {
        return this.messagePinData;
    }

    public void setMessagePinData(MessagePin messagePinData) {
        this.messagePinData = messagePinData;
    }

    public UrlPin getUrlPinData() {
        return this.urlPinData;
    }

    public void setUrlPinData(UrlPin urlPinData) {
        this.urlPinData = urlPinData;
    }

    public static class Builder {
        /**
         * 置顶ID
         * <p> 示例值：7262656565168242692
         */
        private String chatPinId;
        /**
         * 群ID
         * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
         */
        private String chatId;
        /**
         * 置顶类型
         * <p> 示例值：message_pin
         */
        private String chatPinType;
        /**
         * 置顶创建时间，毫秒级别
         * <p> 示例值：1694519103000
         */
        private String createTime;
        /**
         * 创建置顶的操作者ID
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         */
        private String chatterId;
        /**
         * 该置顶是否固定在置顶列表的最前面
         * <p> 示例值：false
         */
        private Boolean isFixed;
        /**
         * 固定置顶到置顶列表前面的操作者ID
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         */
        private String operateFixChatterId;
        /**
         * 消息置顶数据
         * <p> 示例值：
         */
        private MessagePin messagePinData;
        /**
         * url类型置顶数据
         * <p> 示例值：
         */
        private UrlPin urlPinData;

        /**
         * 置顶ID
         * <p> 示例值：7262656565168242692
         *
         * @param chatPinId
         * @return
         */
        public Builder chatPinId(String chatPinId) {
            this.chatPinId = chatPinId;
            return this;
        }


        /**
         * 群ID
         * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
         *
         * @param chatId
         * @return
         */
        public Builder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }


        /**
         * 置顶类型
         * <p> 示例值：message_pin
         *
         * @param chatPinType
         * @return
         */
        public Builder chatPinType(String chatPinType) {
            this.chatPinType = chatPinType;
            return this;
        }

        /**
         * 置顶类型
         * <p> 示例值：message_pin
         *
         * @param chatPinType {@link com.lark.oapi.service.im.v2.enums.ChatPinChatPinTypeEnum}
         * @return
         */
        public Builder chatPinType(com.lark.oapi.service.im.v2.enums.ChatPinChatPinTypeEnum chatPinType) {
            this.chatPinType = chatPinType.getValue();
            return this;
        }


        /**
         * 置顶创建时间，毫秒级别
         * <p> 示例值：1694519103000
         *
         * @param createTime
         * @return
         */
        public Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }


        /**
         * 创建置顶的操作者ID
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         *
         * @param chatterId
         * @return
         */
        public Builder chatterId(String chatterId) {
            this.chatterId = chatterId;
            return this;
        }


        /**
         * 该置顶是否固定在置顶列表的最前面
         * <p> 示例值：false
         *
         * @param isFixed
         * @return
         */
        public Builder isFixed(Boolean isFixed) {
            this.isFixed = isFixed;
            return this;
        }


        /**
         * 固定置顶到置顶列表前面的操作者ID
         * <p> 示例值：ou_7d8a6e6df7621556ce0d21922b676706ccs
         *
         * @param operateFixChatterId
         * @return
         */
        public Builder operateFixChatterId(String operateFixChatterId) {
            this.operateFixChatterId = operateFixChatterId;
            return this;
        }


        /**
         * 消息置顶数据
         * <p> 示例值：
         *
         * @param messagePinData
         * @return
         */
        public Builder messagePinData(MessagePin messagePinData) {
            this.messagePinData = messagePinData;
            return this;
        }


        /**
         * url类型置顶数据
         * <p> 示例值：
         *
         * @param urlPinData
         * @return
         */
        public Builder urlPinData(UrlPin urlPinData) {
            this.urlPinData = urlPinData;
            return this;
        }


        public ChatPin build() {
            return new ChatPin(this);
        }
    }
}
