// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;

import com.google.gson.annotations.SerializedName;

public class DeviceApplyRecord {
    /**
     * 设备申请单id
     * <p> 示例值：321321311
     */
    @SerializedName("apply_id")
    private String applyId;
    /**
     * 设备类型
     * <p> 示例值：Mobile
     */
    @SerializedName("device_terminal_type")
    private String deviceTerminalType;
    /**
     * 设备型号
     * <p> 示例值：MacBookPro16,2
     */
    @SerializedName("model")
    private String model;
    /**
     * 生产序列号
     * <p> 示例值：C02DTHRMML7H
     */
    @SerializedName("serial_number")
    private String serialNumber;
    /**
     * 主板UUID
     * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
     */
    @SerializedName("uuid")
    private String uuid;
    /**
     * Mac地址
     * <p> 示例值：ac:de:48:00:11:22
     */
    @SerializedName("mac_address")
    private String macAddress;
    /**
     * 国际移动设备识别码
     * <p> 示例值：123456-78-901234-5
     */
    @SerializedName("imei")
    private String imei;
    /**
     * Android 标识符
     * <p> 示例值：02a11ac4a83b918e
     */
    @SerializedName("android_id")
    private String androidId;
    /**
     * google广告id
     * <p> 示例值：02a11ac4a83b918e
     */
    @SerializedName("google_aid")
    private String googleAid;
    /**
     * Ios广告主标识符
     * <p> 示例值：EA7583CD-A667-48BC-B806-42ECB2B48606
     */
    @SerializedName("idfa")
    private String idfa;
    /**
     * Ios 供应商标识符
     * <p> 示例值：968F0E5C-C297-4122-ACB6-102494DEFD9A
     */
    @SerializedName("idfv")
    private String idfv;
    /**
     * 申报状态
     * <p> 示例值：Processing
     */
    @SerializedName("apply_status")
    private String applyStatus;
    /**
     * 申请人
     * <p> 示例值：
     */
    @SerializedName("operator")
    private UserId operator;
    /**
     * 申请时间
     * <p> 示例值：2022-11-28 17:21:26
     */
    @SerializedName("apply_time")
    private String applyTime;
    /**
     * 硬盘序列号
     * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
     */
    @SerializedName("disk_serial_number")
    private String diskSerialNumber;
    /**
     * 设备归属
     * <p> 示例值：Company
     */
    @SerializedName("device_ownership")
    private String deviceOwnership;
    /**
     * 操作系统
     * <p> 示例值：Windows
     */
    @SerializedName("device_system")
    private String deviceSystem;
    /**
     * 设备名称
     * <p> 示例值：xx的设备
     */
    @SerializedName("device_name")
    private String deviceName;
    /**
     * 设备单ID
     * <p> 示例值：321321311112
     */
    @SerializedName("device_record_id")
    private String deviceRecordId;

    // builder 开始
    public DeviceApplyRecord() {
    }

    public DeviceApplyRecord(Builder builder) {
        /**
         * 设备申请单id
         * <p> 示例值：321321311
         */
        this.applyId = builder.applyId;
        /**
         * 设备类型
         * <p> 示例值：Mobile
         */
        this.deviceTerminalType = builder.deviceTerminalType;
        /**
         * 设备型号
         * <p> 示例值：MacBookPro16,2
         */
        this.model = builder.model;
        /**
         * 生产序列号
         * <p> 示例值：C02DTHRMML7H
         */
        this.serialNumber = builder.serialNumber;
        /**
         * 主板UUID
         * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
         */
        this.uuid = builder.uuid;
        /**
         * Mac地址
         * <p> 示例值：ac:de:48:00:11:22
         */
        this.macAddress = builder.macAddress;
        /**
         * 国际移动设备识别码
         * <p> 示例值：123456-78-901234-5
         */
        this.imei = builder.imei;
        /**
         * Android 标识符
         * <p> 示例值：02a11ac4a83b918e
         */
        this.androidId = builder.androidId;
        /**
         * google广告id
         * <p> 示例值：02a11ac4a83b918e
         */
        this.googleAid = builder.googleAid;
        /**
         * Ios广告主标识符
         * <p> 示例值：EA7583CD-A667-48BC-B806-42ECB2B48606
         */
        this.idfa = builder.idfa;
        /**
         * Ios 供应商标识符
         * <p> 示例值：968F0E5C-C297-4122-ACB6-102494DEFD9A
         */
        this.idfv = builder.idfv;
        /**
         * 申报状态
         * <p> 示例值：Processing
         */
        this.applyStatus = builder.applyStatus;
        /**
         * 申请人
         * <p> 示例值：
         */
        this.operator = builder.operator;
        /**
         * 申请时间
         * <p> 示例值：2022-11-28 17:21:26
         */
        this.applyTime = builder.applyTime;
        /**
         * 硬盘序列号
         * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
         */
        this.diskSerialNumber = builder.diskSerialNumber;
        /**
         * 设备归属
         * <p> 示例值：Company
         */
        this.deviceOwnership = builder.deviceOwnership;
        /**
         * 操作系统
         * <p> 示例值：Windows
         */
        this.deviceSystem = builder.deviceSystem;
        /**
         * 设备名称
         * <p> 示例值：xx的设备
         */
        this.deviceName = builder.deviceName;
        /**
         * 设备单ID
         * <p> 示例值：321321311112
         */
        this.deviceRecordId = builder.deviceRecordId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getApplyId() {
        return this.applyId;
    }

    public void setApplyId(String applyId) {
        this.applyId = applyId;
    }

    public String getDeviceTerminalType() {
        return this.deviceTerminalType;
    }

    public void setDeviceTerminalType(String deviceTerminalType) {
        this.deviceTerminalType = deviceTerminalType;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getImei() {
        return this.imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getAndroidId() {
        return this.androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public String getGoogleAid() {
        return this.googleAid;
    }

    public void setGoogleAid(String googleAid) {
        this.googleAid = googleAid;
    }

    public String getIdfa() {
        return this.idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfv() {
        return this.idfv;
    }

    public void setIdfv(String idfv) {
        this.idfv = idfv;
    }

    public String getApplyStatus() {
        return this.applyStatus;
    }

    public void setApplyStatus(String applyStatus) {
        this.applyStatus = applyStatus;
    }

    public UserId getOperator() {
        return this.operator;
    }

    public void setOperator(UserId operator) {
        this.operator = operator;
    }

    public String getApplyTime() {
        return this.applyTime;
    }

    public void setApplyTime(String applyTime) {
        this.applyTime = applyTime;
    }

    public String getDiskSerialNumber() {
        return this.diskSerialNumber;
    }

    public void setDiskSerialNumber(String diskSerialNumber) {
        this.diskSerialNumber = diskSerialNumber;
    }

    public String getDeviceOwnership() {
        return this.deviceOwnership;
    }

    public void setDeviceOwnership(String deviceOwnership) {
        this.deviceOwnership = deviceOwnership;
    }

    public String getDeviceSystem() {
        return this.deviceSystem;
    }

    public void setDeviceSystem(String deviceSystem) {
        this.deviceSystem = deviceSystem;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceRecordId() {
        return this.deviceRecordId;
    }

    public void setDeviceRecordId(String deviceRecordId) {
        this.deviceRecordId = deviceRecordId;
    }

    public static class Builder {
        /**
         * 设备申请单id
         * <p> 示例值：321321311
         */
        private String applyId;
        /**
         * 设备类型
         * <p> 示例值：Mobile
         */
        private String deviceTerminalType;
        /**
         * 设备型号
         * <p> 示例值：MacBookPro16,2
         */
        private String model;
        /**
         * 生产序列号
         * <p> 示例值：C02DTHRMML7H
         */
        private String serialNumber;
        /**
         * 主板UUID
         * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
         */
        private String uuid;
        /**
         * Mac地址
         * <p> 示例值：ac:de:48:00:11:22
         */
        private String macAddress;
        /**
         * 国际移动设备识别码
         * <p> 示例值：123456-78-901234-5
         */
        private String imei;
        /**
         * Android 标识符
         * <p> 示例值：02a11ac4a83b918e
         */
        private String androidId;
        /**
         * google广告id
         * <p> 示例值：02a11ac4a83b918e
         */
        private String googleAid;
        /**
         * Ios广告主标识符
         * <p> 示例值：EA7583CD-A667-48BC-B806-42ECB2B48606
         */
        private String idfa;
        /**
         * Ios 供应商标识符
         * <p> 示例值：968F0E5C-C297-4122-ACB6-102494DEFD9A
         */
        private String idfv;
        /**
         * 申报状态
         * <p> 示例值：Processing
         */
        private String applyStatus;
        /**
         * 申请人
         * <p> 示例值：
         */
        private UserId operator;
        /**
         * 申请时间
         * <p> 示例值：2022-11-28 17:21:26
         */
        private String applyTime;
        /**
         * 硬盘序列号
         * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
         */
        private String diskSerialNumber;
        /**
         * 设备归属
         * <p> 示例值：Company
         */
        private String deviceOwnership;
        /**
         * 操作系统
         * <p> 示例值：Windows
         */
        private String deviceSystem;
        /**
         * 设备名称
         * <p> 示例值：xx的设备
         */
        private String deviceName;
        /**
         * 设备单ID
         * <p> 示例值：321321311112
         */
        private String deviceRecordId;

        /**
         * 设备申请单id
         * <p> 示例值：321321311
         *
         * @param applyId
         * @return
         */
        public Builder applyId(String applyId) {
            this.applyId = applyId;
            return this;
        }


        /**
         * 设备类型
         * <p> 示例值：Mobile
         *
         * @param deviceTerminalType
         * @return
         */
        public Builder deviceTerminalType(String deviceTerminalType) {
            this.deviceTerminalType = deviceTerminalType;
            return this;
        }

        /**
         * 设备类型
         * <p> 示例值：Mobile
         *
         * @param deviceTerminalType {@link com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceTerminalTypeEnum}
         * @return
         */
        public Builder deviceTerminalType(com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceTerminalTypeEnum deviceTerminalType) {
            this.deviceTerminalType = deviceTerminalType.getValue();
            return this;
        }


        /**
         * 设备型号
         * <p> 示例值：MacBookPro16,2
         *
         * @param model
         * @return
         */
        public Builder model(String model) {
            this.model = model;
            return this;
        }


        /**
         * 生产序列号
         * <p> 示例值：C02DTHRMML7H
         *
         * @param serialNumber
         * @return
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }


        /**
         * 主板UUID
         * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
         *
         * @param uuid
         * @return
         */
        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }


        /**
         * Mac地址
         * <p> 示例值：ac:de:48:00:11:22
         *
         * @param macAddress
         * @return
         */
        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }


        /**
         * 国际移动设备识别码
         * <p> 示例值：123456-78-901234-5
         *
         * @param imei
         * @return
         */
        public Builder imei(String imei) {
            this.imei = imei;
            return this;
        }


        /**
         * Android 标识符
         * <p> 示例值：02a11ac4a83b918e
         *
         * @param androidId
         * @return
         */
        public Builder androidId(String androidId) {
            this.androidId = androidId;
            return this;
        }


        /**
         * google广告id
         * <p> 示例值：02a11ac4a83b918e
         *
         * @param googleAid
         * @return
         */
        public Builder googleAid(String googleAid) {
            this.googleAid = googleAid;
            return this;
        }


        /**
         * Ios广告主标识符
         * <p> 示例值：EA7583CD-A667-48BC-B806-42ECB2B48606
         *
         * @param idfa
         * @return
         */
        public Builder idfa(String idfa) {
            this.idfa = idfa;
            return this;
        }


        /**
         * Ios 供应商标识符
         * <p> 示例值：968F0E5C-C297-4122-ACB6-102494DEFD9A
         *
         * @param idfv
         * @return
         */
        public Builder idfv(String idfv) {
            this.idfv = idfv;
            return this;
        }


        /**
         * 申报状态
         * <p> 示例值：Processing
         *
         * @param applyStatus
         * @return
         */
        public Builder applyStatus(String applyStatus) {
            this.applyStatus = applyStatus;
            return this;
        }

        /**
         * 申报状态
         * <p> 示例值：Processing
         *
         * @param applyStatus {@link com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceApplyStatusEnum}
         * @return
         */
        public Builder applyStatus(com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceApplyStatusEnum applyStatus) {
            this.applyStatus = applyStatus.getValue();
            return this;
        }


        /**
         * 申请人
         * <p> 示例值：
         *
         * @param operator
         * @return
         */
        public Builder operator(UserId operator) {
            this.operator = operator;
            return this;
        }


        /**
         * 申请时间
         * <p> 示例值：2022-11-28 17:21:26
         *
         * @param applyTime
         * @return
         */
        public Builder applyTime(String applyTime) {
            this.applyTime = applyTime;
            return this;
        }


        /**
         * 硬盘序列号
         * <p> 示例值：CC344362-5990-5A68-8DDD-64A23C99FA0C
         *
         * @param diskSerialNumber
         * @return
         */
        public Builder diskSerialNumber(String diskSerialNumber) {
            this.diskSerialNumber = diskSerialNumber;
            return this;
        }


        /**
         * 设备归属
         * <p> 示例值：Company
         *
         * @param deviceOwnership
         * @return
         */
        public Builder deviceOwnership(String deviceOwnership) {
            this.deviceOwnership = deviceOwnership;
            return this;
        }

        /**
         * 设备归属
         * <p> 示例值：Company
         *
         * @param deviceOwnership {@link com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceOwnershipEnum}
         * @return
         */
        public Builder deviceOwnership(com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceOwnershipEnum deviceOwnership) {
            this.deviceOwnership = deviceOwnership.getValue();
            return this;
        }


        /**
         * 操作系统
         * <p> 示例值：Windows
         *
         * @param deviceSystem
         * @return
         */
        public Builder deviceSystem(String deviceSystem) {
            this.deviceSystem = deviceSystem;
            return this;
        }

        /**
         * 操作系统
         * <p> 示例值：Windows
         *
         * @param deviceSystem {@link com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceSystemEnum}
         * @return
         */
        public Builder deviceSystem(com.lark.oapi.service.security_and_compliance.v1.enums.DeviceApplyRecordDeviceSystemEnum deviceSystem) {
            this.deviceSystem = deviceSystem.getValue();
            return this;
        }


        /**
         * 设备名称
         * <p> 示例值：xx的设备
         *
         * @param deviceName
         * @return
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }


        /**
         * 设备单ID
         * <p> 示例值：321321311112
         *
         * @param deviceRecordId
         * @return
         */
        public Builder deviceRecordId(String deviceRecordId) {
            this.deviceRecordId = deviceRecordId;
            return this;
        }


        public DeviceApplyRecord build() {
            return new DeviceApplyRecord(this);
        }
    }
}
