/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.document_ai.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.document_ai.v1.model.RecognizeIdCardReq;
import com.lark.oapi.service.document_ai.v1.model.RecognizeIdCardResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCard {
    private static final Logger log = LoggerFactory.getLogger(IdCard.class);
    private final Config config;

    public IdCard(Config config) {
        this.config = config;
    }

    public RecognizeIdCardResp recognize(RecognizeIdCardReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/id_card/recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
        RecognizeIdCardResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeIdCardResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/id_card/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public RecognizeIdCardResp recognize(RecognizeIdCardReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/id_card/recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
        RecognizeIdCardResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeIdCardResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/id_card/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

