// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.admin.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.admin.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class GetBadgeGrantReq {
    /**
     * 用户 ID 类型
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 此次调用中使用的部门ID的类型。
     * <p> 示例值：open_department_id
     */
    @Query
    @SerializedName("department_id_type")
    private String departmentIdType;
    /**
     * 租户内勋章的唯一标识，该值由系统随机生成。
     * <p> 示例值：m_DjMzaK
     */
    @Path
    @SerializedName("badge_id")
    private String badgeId;
    /**
     * 租户内授予名单的唯一标识，该值由系统随机生成。
     * <p> 示例值：g_uS4yux
     */
    @Path
    @SerializedName("grant_id")
    private String grantId;

    // builder 开始
    public GetBadgeGrantReq() {
    }

    public GetBadgeGrantReq(Builder builder) {
        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 此次调用中使用的部门ID的类型。
         * <p> 示例值：open_department_id
         */
        this.departmentIdType = builder.departmentIdType;
        /**
         * 租户内勋章的唯一标识，该值由系统随机生成。
         * <p> 示例值：m_DjMzaK
         */
        this.badgeId = builder.badgeId;
        /**
         * 租户内授予名单的唯一标识，该值由系统随机生成。
         * <p> 示例值：g_uS4yux
         */
        this.grantId = builder.grantId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getDepartmentIdType() {
        return this.departmentIdType;
    }

    public void setDepartmentIdType(String departmentIdType) {
        this.departmentIdType = departmentIdType;
    }

    public String getBadgeId() {
        return this.badgeId;
    }

    public void setBadgeId(String badgeId) {
        this.badgeId = badgeId;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    public static class Builder {
        private String userIdType; // 用户 ID 类型
        private String departmentIdType; // 此次调用中使用的部门ID的类型。
        private String badgeId; // 租户内勋章的唯一标识，该值由系统随机生成。
        private String grantId; // 租户内授予名单的唯一标识，该值由系统随机生成。

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         *
         * @param userIdType {@link com.lark.oapi.service.admin.v1.enums.GetBadgeGrantUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.admin.v1.enums.GetBadgeGrantUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        /**
         * 此次调用中使用的部门ID的类型。
         * <p> 示例值：open_department_id
         *
         * @param departmentIdType
         * @return
         */
        public Builder departmentIdType(String departmentIdType) {
            this.departmentIdType = departmentIdType;
            return this;
        }

        /**
         * 此次调用中使用的部门ID的类型。
         * <p> 示例值：open_department_id
         *
         * @param departmentIdType {@link com.lark.oapi.service.admin.v1.enums.GetBadgeGrantDepartmentIdTypeEnum}
         * @return
         */
        public Builder departmentIdType(com.lark.oapi.service.admin.v1.enums.GetBadgeGrantDepartmentIdTypeEnum departmentIdType) {
            this.departmentIdType = departmentIdType.getValue();
            return this;
        }

        /**
         * 租户内勋章的唯一标识，该值由系统随机生成。
         * <p> 示例值：m_DjMzaK
         *
         * @param badgeId
         * @return
         */
        public Builder badgeId(String badgeId) {
            this.badgeId = badgeId;
            return this;
        }


        /**
         * 租户内授予名单的唯一标识，该值由系统随机生成。
         * <p> 示例值：g_uS4yux
         *
         * @param grantId
         * @return
         */
        public Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public GetBadgeGrantReq build() {
            return new GetBadgeGrantReq(this);
        }
    }
}
