// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.authen.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class GetAuthorizeReq {
    /**
     * 应用 ID，可以在开发者后台的-凭证与基础信息-页面查看 app_id，格式cli_xxx
     * <p> 示例值：cli_9dff7f6ae02ad104
     */
    @Query
    @SerializedName("app_id")
    private String appId;
    /**
     * 应用回调地址，url需经过 "application/x-www-form-urlencoded" 格式编码。调用本接口前, 需要在开发者后台的**安全设置**页面配置重定向URL，支持配置多个。只有在重定向URL列表中的URL才会通过开放平台的安全校验
     * <p> 示例值：https%3A%2F%2F127.0.0.1%2Fmock
     */
    @Query
    @SerializedName("redirect_uri")
    private String redirectUri;
    /**
     * 用户授予app的权限，参数格式是不同scope由空格分隔，区分大小写的字符串。业务需要根据自己内部场景，自主拼接调用open-api所需的scope。scope详细说明请参考：[申请API权限](https://open.feishu.cn/document/server-docs/application-scope/introduction)
     * <p> 示例值：contact:contact bitable:app:readonly
     */
    @Query
    @SerializedName("scope")
    private String scope;
    /**
     * 用来维护请求和回调状态的附加字符串， 在授权完成回调时会附加此参数，应用可以根据此字符串来判断上下文关系
     * <p> 示例值：RANDOMSTATE
     */
    @Query
    @SerializedName("state")
    private String state;

    // builder 开始
    public GetAuthorizeReq() {
    }

    public GetAuthorizeReq(Builder builder) {
        /**
         * 应用 ID，可以在开发者后台的-凭证与基础信息-页面查看 app_id，格式cli_xxx
         * <p> 示例值：cli_9dff7f6ae02ad104
         */
        this.appId = builder.appId;
        /**
         * 应用回调地址，url需经过 "application/x-www-form-urlencoded" 格式编码。调用本接口前, 需要在开发者后台的**安全设置**页面配置重定向URL，支持配置多个。只有在重定向URL列表中的URL才会通过开放平台的安全校验
         * <p> 示例值：https%3A%2F%2F127.0.0.1%2Fmock
         */
        this.redirectUri = builder.redirectUri;
        /**
         * 用户授予app的权限，参数格式是不同scope由空格分隔，区分大小写的字符串。业务需要根据自己内部场景，自主拼接调用open-api所需的scope。scope详细说明请参考：[申请API权限](https://open.feishu.cn/document/server-docs/application-scope/introduction)
         * <p> 示例值：contact:contact bitable:app:readonly
         */
        this.scope = builder.scope;
        /**
         * 用来维护请求和回调状态的附加字符串， 在授权完成回调时会附加此参数，应用可以根据此字符串来判断上下文关系
         * <p> 示例值：RANDOMSTATE
         */
        this.state = builder.state;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public static class Builder {
        private String appId; // 应用 ID，可以在开发者后台的-凭证与基础信息-页面查看 app_id，格式cli_xxx
        private String redirectUri; // 应用回调地址，url需经过 "application/x-www-form-urlencoded" 格式编码。调用本接口前, 需要在开发者后台的**安全设置**页面配置重定向URL，支持配置多个。只有在重定向URL列表中的URL才会通过开放平台的安全校验
        private String scope; // 用户授予app的权限，参数格式是不同scope由空格分隔，区分大小写的字符串。业务需要根据自己内部场景，自主拼接调用open-api所需的scope。scope详细说明请参考：[申请API权限](https://open.feishu.cn/document/server-docs/application-scope/introduction)
        private String state; // 用来维护请求和回调状态的附加字符串， 在授权完成回调时会附加此参数，应用可以根据此字符串来判断上下文关系


        /**
         * 应用 ID，可以在开发者后台的-凭证与基础信息-页面查看 app_id，格式cli_xxx
         * <p> 示例值：cli_9dff7f6ae02ad104
         *
         * @param appId
         * @return
         */
        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }


        /**
         * 应用回调地址，url需经过 "application/x-www-form-urlencoded" 格式编码。调用本接口前, 需要在开发者后台的**安全设置**页面配置重定向URL，支持配置多个。只有在重定向URL列表中的URL才会通过开放平台的安全校验
         * <p> 示例值：https%3A%2F%2F127.0.0.1%2Fmock
         *
         * @param redirectUri
         * @return
         */
        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }


        /**
         * 用户授予app的权限，参数格式是不同scope由空格分隔，区分大小写的字符串。业务需要根据自己内部场景，自主拼接调用open-api所需的scope。scope详细说明请参考：[申请API权限](https://open.feishu.cn/document/server-docs/application-scope/introduction)
         * <p> 示例值：contact:contact bitable:app:readonly
         *
         * @param scope
         * @return
         */
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }


        /**
         * 用来维护请求和回调状态的附加字符串， 在授权完成回调时会附加此参数，应用可以根据此字符串来判断上下文关系
         * <p> 示例值：RANDOMSTATE
         *
         * @param state
         * @return
         */
        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public GetAuthorizeReq build() {
            return new GetAuthorizeReq(this);
        }
    }
}
