// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.task.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Reminder {
    /**
     * 提醒时间设置的 ID（在删除时候需要使用这个）
     * <p> 示例值：1
     */
    @SerializedName("id")
    private String id;
    /**
     * 相对于截止时间的提醒时间（如提前 30 分钟，截止时间后 30 分钟，则为 -30） 任务没有截止时间则为全天任务(截止时间为0)
     * <p> 示例值：30
     */
    @SerializedName("relative_fire_minute")
    private Integer relativeFireMinute;

    // builder 开始
    public Reminder() {
    }

    public Reminder(Builder builder) {
        /**
         * 提醒时间设置的 ID（在删除时候需要使用这个）
         * <p> 示例值：1
         */
        this.id = builder.id;
        /**
         * 相对于截止时间的提醒时间（如提前 30 分钟，截止时间后 30 分钟，则为 -30） 任务没有截止时间则为全天任务(截止时间为0)
         * <p> 示例值：30
         */
        this.relativeFireMinute = builder.relativeFireMinute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getRelativeFireMinute() {
        return this.relativeFireMinute;
    }

    public void setRelativeFireMinute(Integer relativeFireMinute) {
        this.relativeFireMinute = relativeFireMinute;
    }

    public static class Builder {
        /**
         * 提醒时间设置的 ID（在删除时候需要使用这个）
         * <p> 示例值：1
         */
        private String id;
        /**
         * 相对于截止时间的提醒时间（如提前 30 分钟，截止时间后 30 分钟，则为 -30） 任务没有截止时间则为全天任务(截止时间为0)
         * <p> 示例值：30
         */
        private Integer relativeFireMinute;

        /**
         * 提醒时间设置的 ID（在删除时候需要使用这个）
         * <p> 示例值：1
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 相对于截止时间的提醒时间（如提前 30 分钟，截止时间后 30 分钟，则为 -30） 任务没有截止时间则为全天任务(截止时间为0)
         * <p> 示例值：30
         *
         * @param relativeFireMinute
         * @return
         */
        public Builder relativeFireMinute(Integer relativeFireMinute) {
            this.relativeFireMinute = relativeFireMinute;
            return this;
        }


        public Reminder build() {
            return new Reminder(this);
        }
    }
}
