// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.drive.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UploadAllFileReqBody {
    /**
     * 文件名。
     * <p> 示例值：demo.pdf
     */
    @SerializedName("file_name")
    private String fileName;
    /**
     * 上传点类型。
     * <p> 示例值：explorer
     */
    @SerializedName("parent_type")
    private String parentType;
    /**
     * 文件夹token，;获取方式见 [概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/files/guide/introduction)
     * <p> 示例值：fldbcO1UuPz8VwnpPx5a92abcef
     */
    @SerializedName("parent_node")
    private String parentNode;
    /**
     * 文件大小（以字节为单位）。
     * <p> 示例值：1024
     */
    @SerializedName("size")
    private Integer size;
    /**
     * 文件adler32校验和(可选)。
     * <p> 示例值：123423882374238912356
     */
    @SerializedName("checksum")
    private String checksum;
    /**
     * 文件二进制内容。
     * <p> 示例值：file binary
     */
    @SerializedName("file")
    private java.io.File file;

    // builder 开始
    public UploadAllFileReqBody() {
    }

    public UploadAllFileReqBody(Builder builder) {
        /**
         * 文件名。
         * <p> 示例值：demo.pdf
         */
        this.fileName = builder.fileName;
        /**
         * 上传点类型。
         * <p> 示例值：explorer
         */
        this.parentType = builder.parentType;
        /**
         * 文件夹token，;获取方式见 [概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/files/guide/introduction)
         * <p> 示例值：fldbcO1UuPz8VwnpPx5a92abcef
         */
        this.parentNode = builder.parentNode;
        /**
         * 文件大小（以字节为单位）。
         * <p> 示例值：1024
         */
        this.size = builder.size;
        /**
         * 文件adler32校验和(可选)。
         * <p> 示例值：123423882374238912356
         */
        this.checksum = builder.checksum;
        /**
         * 文件二进制内容。
         * <p> 示例值：file binary
         */
        this.file = builder.file;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getParentType() {
        return this.parentType;
    }

    public void setParentType(String parentType) {
        this.parentType = parentType;
    }

    public String getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(String parentNode) {
        this.parentNode = parentNode;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public java.io.File getFile() {
        return this.file;
    }

    public void setFile(java.io.File file) {
        this.file = file;
    }

    public static class Builder {
        /**
         * 文件名。
         * <p> 示例值：demo.pdf
         */
        private String fileName;
        /**
         * 上传点类型。
         * <p> 示例值：explorer
         */
        private String parentType;
        /**
         * 文件夹token，;获取方式见 [概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/files/guide/introduction)
         * <p> 示例值：fldbcO1UuPz8VwnpPx5a92abcef
         */
        private String parentNode;
        /**
         * 文件大小（以字节为单位）。
         * <p> 示例值：1024
         */
        private Integer size;
        /**
         * 文件adler32校验和(可选)。
         * <p> 示例值：123423882374238912356
         */
        private String checksum;
        /**
         * 文件二进制内容。
         * <p> 示例值：file binary
         */
        private java.io.File file;

        /**
         * 文件名。
         * <p> 示例值：demo.pdf
         *
         * @param fileName
         * @return
         */
        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }


        /**
         * 上传点类型。
         * <p> 示例值：explorer
         *
         * @param parentType
         * @return
         */
        public Builder parentType(String parentType) {
            this.parentType = parentType;
            return this;
        }

        /**
         * 上传点类型。
         * <p> 示例值：explorer
         *
         * @param parentType {@link com.lark.oapi.service.drive.v1.enums.UploadAllFileParentTypeEnum}
         * @return
         */
        public Builder parentType(com.lark.oapi.service.drive.v1.enums.UploadAllFileParentTypeEnum parentType) {
            this.parentType = parentType.getValue();
            return this;
        }


        /**
         * 文件夹token，;获取方式见 [概述](https://open.feishu.cn/document/ukTMukTMukTM/uUDN04SN0QjL1QDN/files/guide/introduction)
         * <p> 示例值：fldbcO1UuPz8VwnpPx5a92abcef
         *
         * @param parentNode
         * @return
         */
        public Builder parentNode(String parentNode) {
            this.parentNode = parentNode;
            return this;
        }


        /**
         * 文件大小（以字节为单位）。
         * <p> 示例值：1024
         *
         * @param size
         * @return
         */
        public Builder size(Integer size) {
            this.size = size;
            return this;
        }


        /**
         * 文件adler32校验和(可选)。
         * <p> 示例值：123423882374238912356
         *
         * @param checksum
         * @return
         */
        public Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }


        /**
         * 文件二进制内容。
         * <p> 示例值：file binary
         *
         * @param file
         * @return
         */
        public Builder file(java.io.File file) {
            this.file = file;
            return this;
        }


        public UploadAllFileReqBody build() {
            return new UploadAllFileReqBody(this);
        }
    }
}
