// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.task.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class InputSection {
    /**
     * 自定义分组名
     * <p> 示例值：已经审核过的任务
     */
    @SerializedName("name")
    private String name;
    /**
     * 自定义分组的资源类型
     * <p> 示例值：tasklist
     */
    @SerializedName("resource_type")
    private String resourceType;
    /**
     * 自定义分组要归属的资源id
     * <p> 示例值：cc371766-6584-cf50-a222-c22cd9055004
     */
    @SerializedName("resource_id")
    private String resourceId;
    /**
     * 要将新分组插入到自定义分分组的前面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
     * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
     */
    @SerializedName("insert_before")
    private String insertBefore;
    /**
     * 要将新分组插入到自定义分分组的后面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
     * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
     */
    @SerializedName("insert_after")
    private String insertAfter;

    // builder 开始
    public InputSection() {
    }

    public InputSection(Builder builder) {
        /**
         * 自定义分组名
         * <p> 示例值：已经审核过的任务
         */
        this.name = builder.name;
        /**
         * 自定义分组的资源类型
         * <p> 示例值：tasklist
         */
        this.resourceType = builder.resourceType;
        /**
         * 自定义分组要归属的资源id
         * <p> 示例值：cc371766-6584-cf50-a222-c22cd9055004
         */
        this.resourceId = builder.resourceId;
        /**
         * 要将新分组插入到自定义分分组的前面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
         * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
         */
        this.insertBefore = builder.insertBefore;
        /**
         * 要将新分组插入到自定义分分组的后面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
         * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
         */
        this.insertAfter = builder.insertAfter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getInsertBefore() {
        return this.insertBefore;
    }

    public void setInsertBefore(String insertBefore) {
        this.insertBefore = insertBefore;
    }

    public String getInsertAfter() {
        return this.insertAfter;
    }

    public void setInsertAfter(String insertAfter) {
        this.insertAfter = insertAfter;
    }

    public static class Builder {
        /**
         * 自定义分组名
         * <p> 示例值：已经审核过的任务
         */
        private String name;
        /**
         * 自定义分组的资源类型
         * <p> 示例值：tasklist
         */
        private String resourceType;
        /**
         * 自定义分组要归属的资源id
         * <p> 示例值：cc371766-6584-cf50-a222-c22cd9055004
         */
        private String resourceId;
        /**
         * 要将新分组插入到自定义分分组的前面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
         * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
         */
        private String insertBefore;
        /**
         * 要将新分组插入到自定义分分组的后面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
         * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
         */
        private String insertAfter;

        /**
         * 自定义分组名
         * <p> 示例值：已经审核过的任务
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 自定义分组的资源类型
         * <p> 示例值：tasklist
         *
         * @param resourceType
         * @return
         */
        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }


        /**
         * 自定义分组要归属的资源id
         * <p> 示例值：cc371766-6584-cf50-a222-c22cd9055004
         *
         * @param resourceId
         * @return
         */
        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }


        /**
         * 要将新分组插入到自定义分分组的前面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
         * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
         *
         * @param insertBefore
         * @return
         */
        public Builder insertBefore(String insertBefore) {
            this.insertBefore = insertBefore;
            return this;
        }


        /**
         * 要将新分组插入到自定义分分组的后面的目标分组的guid。insert_before/insert_after二选一。也可以都不设置。都不设置时表示将新分组查到对应容器的最前面。
         * <p> 示例值：e6e37dcc-f75a-5936-f589-12fb4b5c80c2
         *
         * @param insertAfter
         * @return
         */
        public Builder insertAfter(String insertAfter) {
            this.insertAfter = insertAfter;
            return this;
        }


        public InputSection build() {
            return new InputSection(this);
        }
    }
}
