// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.application.v6.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class PatchApplicationAppVersionReq {
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 操作者的 open_id
     * <p> 示例值：ou_4065981088f8ef67a504ba8bd6b24d85
     */
    @Query
    @SerializedName("operator_id")
    private String operatorId;
    /**
     * 当修改版本状态为被驳回时，这一项必填
     * <p> 示例值：拒绝理由
     */
    @Query
    @SerializedName("reject_reason")
    private String rejectReason;
    /**
     * 应用 id
     * <p> 示例值：cli_9f3ca975326b501b
     */
    @Path
    @SerializedName("app_id")
    private String appId;
    /**
     * 唯一标识应用版本的 ID
     * <p> 示例值：oav_d317f090b7258ad0372aa53963cda70d
     */
    @Path
    @SerializedName("version_id")
    private String versionId;
    @Body
    private ApplicationAppVersion body;

    // builder 开始
    public PatchApplicationAppVersionReq() {
    }

    public PatchApplicationAppVersionReq(Builder builder) {
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
        /**
         * 操作者的 open_id
         * <p> 示例值：ou_4065981088f8ef67a504ba8bd6b24d85
         */
        this.operatorId = builder.operatorId;
        /**
         * 当修改版本状态为被驳回时，这一项必填
         * <p> 示例值：拒绝理由
         */
        this.rejectReason = builder.rejectReason;
        /**
         * 应用 id
         * <p> 示例值：cli_9f3ca975326b501b
         */
        this.appId = builder.appId;
        /**
         * 唯一标识应用版本的 ID
         * <p> 示例值：oav_d317f090b7258ad0372aa53963cda70d
         */
        this.versionId = builder.versionId;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public ApplicationAppVersion getApplicationAppVersion() {
        return this.body;
    }

    public void setApplicationAppVersion(ApplicationAppVersion body) {
        this.body = body;
    }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String operatorId; // 操作者的 open_id
        private String rejectReason; // 当修改版本状态为被驳回时，这一项必填
        private String appId; // 应用 id
        private String versionId; // 唯一标识应用版本的 ID
        private ApplicationAppVersion body;

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.application.v6.enums.PatchApplicationAppVersionUpdateAppVersionUserIDTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.application.v6.enums.PatchApplicationAppVersionUpdateAppVersionUserIDTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        /**
         * 操作者的 open_id
         * <p> 示例值：ou_4065981088f8ef67a504ba8bd6b24d85
         *
         * @param operatorId
         * @return
         */
        public Builder operatorId(String operatorId) {
            this.operatorId = operatorId;
            return this;
        }

        /**
         * 当修改版本状态为被驳回时，这一项必填
         * <p> 示例值：拒绝理由
         *
         * @param rejectReason
         * @return
         */
        public Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        /**
         * 应用 id
         * <p> 示例值：cli_9f3ca975326b501b
         *
         * @param appId
         * @return
         */
        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * 唯一标识应用版本的 ID
         * <p> 示例值：oav_d317f090b7258ad0372aa53963cda70d
         *
         * @param versionId
         * @return
         */
        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public ApplicationAppVersion getApplicationAppVersion() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder applicationAppVersion(ApplicationAppVersion body) {
            this.body = body;
            return this;
        }

        public PatchApplicationAppVersionReq build() {
            return new PatchApplicationAppVersionReq(this);
        }
    }
}
