// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ListInterviewerReq {
    /**
     * 分页大小
     * <p> 示例值：
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
     * <p> 示例值：
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 面试官userID列表
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_ids")
    private String[] userIds;
    /**
     * 认证状态
     * <p> 示例值：1
     */
    @Query
    @SerializedName("verify_status")
    private Integer verifyStatus;
    /**
     * 最早更新时间，毫秒时间戳
     * <p> 示例值：1714374796615
     */
    @Query
    @SerializedName("earliest_update_time")
    private String earliestUpdateTime;
    /**
     * 最晚更新时间，毫秒时间戳
     * <p> 示例值：1714374796616
     */
    @Query
    @SerializedName("latest_update_time")
    private String latestUpdateTime;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;

    // builder 开始
    public ListInterviewerReq() {
    }

    public ListInterviewerReq(Builder builder) {
        /**
         * 分页大小
         * <p> 示例值：
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：
         */
        this.pageToken = builder.pageToken;
        /**
         * 面试官userID列表
         * <p> 示例值：
         */
        this.userIds = builder.userIds;
        /**
         * 认证状态
         * <p> 示例值：1
         */
        this.verifyStatus = builder.verifyStatus;
        /**
         * 最早更新时间，毫秒时间戳
         * <p> 示例值：1714374796615
         */
        this.earliestUpdateTime = builder.earliestUpdateTime;
        /**
         * 最晚更新时间，毫秒时间戳
         * <p> 示例值：1714374796616
         */
        this.latestUpdateTime = builder.latestUpdateTime;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String[] userIds) {
        this.userIds = userIds;
    }

    public Integer getVerifyStatus() {
        return this.verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public String getEarliestUpdateTime() {
        return this.earliestUpdateTime;
    }

    public void setEarliestUpdateTime(String earliestUpdateTime) {
        this.earliestUpdateTime = earliestUpdateTime;
    }

    public String getLatestUpdateTime() {
        return this.latestUpdateTime;
    }

    public void setLatestUpdateTime(String latestUpdateTime) {
        this.latestUpdateTime = latestUpdateTime;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public static class Builder {
        private Integer pageSize; // 分页大小
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
        private String[] userIds; // 面试官userID列表
        private Integer verifyStatus; // 认证状态
        private String earliestUpdateTime; // 最早更新时间，毫秒时间戳
        private String latestUpdateTime; // 最晚更新时间，毫秒时间戳
        private String userIdType; // 此次调用中使用的用户ID的类型


        /**
         * 分页大小
         * <p> 示例值：
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 面试官userID列表
         * <p> 示例值：
         *
         * @param userIds
         * @return
         */
        public Builder userIds(String[] userIds) {
            this.userIds = userIds;
            return this;
        }


        /**
         * 认证状态
         * <p> 示例值：1
         *
         * @param verifyStatus
         * @return
         */
        public Builder verifyStatus(Integer verifyStatus) {
            this.verifyStatus = verifyStatus;
            return this;
        }


        /**
         * 最早更新时间，毫秒时间戳
         * <p> 示例值：1714374796615
         *
         * @param earliestUpdateTime
         * @return
         */
        public Builder earliestUpdateTime(String earliestUpdateTime) {
            this.earliestUpdateTime = earliestUpdateTime;
            return this;
        }


        /**
         * 最晚更新时间，毫秒时间戳
         * <p> 示例值：1714374796616
         *
         * @param latestUpdateTime
         * @return
         */
        public Builder latestUpdateTime(String latestUpdateTime) {
            this.latestUpdateTime = latestUpdateTime;
            return this;
        }


        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        public ListInterviewerReq build() {
            return new ListInterviewerReq(this);
        }
    }
}
