/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.baike.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.baike.v1.model.DownloadFileReq;
import com.lark.oapi.service.baike.v1.model.DownloadFileResp;
import com.lark.oapi.service.baike.v1.model.UploadFileReq;
import com.lark.oapi.service.baike.v1.model.UploadFileResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File {
    private static final Logger log = LoggerFactory.getLogger(File.class);
    private final Config config;

    public File(Config config) {
        this.config = config;
    }

    public DownloadFileResp download(DownloadFileReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/files/:file_token/download", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        if (httpResponse.getStatusCode() == 200) {
            DownloadFileResp resp = new DownloadFileResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        DownloadFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadFileResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/baike/v1/files/:file_token/download", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public DownloadFileResp download(DownloadFileReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/baike/v1/files/:file_token/download", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        if (httpResponse.getStatusCode() == 200) {
            DownloadFileResp resp = new DownloadFileResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        DownloadFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadFileResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/baike/v1/files/:file_token/download", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UploadFileResp upload(UploadFileReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/files/upload", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        UploadFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadFileResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/baike/v1/files/upload", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UploadFileResp upload(UploadFileReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/baike/v1/files/upload", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        UploadFileResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UploadFileResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/baike/v1/files/upload", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

