// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.im.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Mention {
    /**
     * 被@的用户或机器人的序号。例如，第3个被@到的成员，值为“@_user_3”
     * <p> 示例值：@_user_1
     */
    @SerializedName("key")
    private String key;
    /**
     * 被@的用户或者机器人的open_id
     * <p> 示例值：ou_155184d1e73cbfb8973e5a9e698e74f2
     */
    @SerializedName("id")
    private String id;
    /**
     * 被@的用户或机器人 id 类型，目前仅支持 `open_id` ([什么是 Open ID？](https://open.feishu.cn/document/home/user-identity-introduction/open-id))
     * <p> 示例值：open_id
     */
    @SerializedName("id_type")
    private String idType;
    /**
     * 被@的用户或机器人的姓名
     * <p> 示例值：Tom
     */
    @SerializedName("name")
    private String name;
    /**
     * 为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用里面的唯一标识
     * <p> 示例值：736588c9260f175e
     */
    @SerializedName("tenant_key")
    private String tenantKey;

    // builder 开始
    public Mention() {
    }

    public Mention(Builder builder) {
        /**
         * 被@的用户或机器人的序号。例如，第3个被@到的成员，值为“@_user_3”
         * <p> 示例值：@_user_1
         */
        this.key = builder.key;
        /**
         * 被@的用户或者机器人的open_id
         * <p> 示例值：ou_155184d1e73cbfb8973e5a9e698e74f2
         */
        this.id = builder.id;
        /**
         * 被@的用户或机器人 id 类型，目前仅支持 `open_id` ([什么是 Open ID？](https://open.feishu.cn/document/home/user-identity-introduction/open-id))
         * <p> 示例值：open_id
         */
        this.idType = builder.idType;
        /**
         * 被@的用户或机器人的姓名
         * <p> 示例值：Tom
         */
        this.name = builder.name;
        /**
         * 为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用里面的唯一标识
         * <p> 示例值：736588c9260f175e
         */
        this.tenantKey = builder.tenantKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTenantKey() {
        return this.tenantKey;
    }

    public void setTenantKey(String tenantKey) {
        this.tenantKey = tenantKey;
    }

    public static class Builder {
        /**
         * 被@的用户或机器人的序号。例如，第3个被@到的成员，值为“@_user_3”
         * <p> 示例值：@_user_1
         */
        private String key;
        /**
         * 被@的用户或者机器人的open_id
         * <p> 示例值：ou_155184d1e73cbfb8973e5a9e698e74f2
         */
        private String id;
        /**
         * 被@的用户或机器人 id 类型，目前仅支持 `open_id` ([什么是 Open ID？](https://open.feishu.cn/document/home/user-identity-introduction/open-id))
         * <p> 示例值：open_id
         */
        private String idType;
        /**
         * 被@的用户或机器人的姓名
         * <p> 示例值：Tom
         */
        private String name;
        /**
         * 为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用里面的唯一标识
         * <p> 示例值：736588c9260f175e
         */
        private String tenantKey;

        /**
         * 被@的用户或机器人的序号。例如，第3个被@到的成员，值为“@_user_3”
         * <p> 示例值：@_user_1
         *
         * @param key
         * @return
         */
        public Builder key(String key) {
            this.key = key;
            return this;
        }


        /**
         * 被@的用户或者机器人的open_id
         * <p> 示例值：ou_155184d1e73cbfb8973e5a9e698e74f2
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 被@的用户或机器人 id 类型，目前仅支持 `open_id` ([什么是 Open ID？](https://open.feishu.cn/document/home/user-identity-introduction/open-id))
         * <p> 示例值：open_id
         *
         * @param idType
         * @return
         */
        public Builder idType(String idType) {
            this.idType = idType;
            return this;
        }


        /**
         * 被@的用户或机器人的姓名
         * <p> 示例值：Tom
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用里面的唯一标识
         * <p> 示例值：736588c9260f175e
         *
         * @param tenantKey
         * @return
         */
        public Builder tenantKey(String tenantKey) {
            this.tenantKey = tenantKey;
            return this;
        }


        public Mention build() {
            return new Mention(this);
        }
    }
}
