// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.lingo.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.lingo.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class I18nEntryDesc {
    /**
     * 语言类型
     * <p> 示例值：1
     */
    @SerializedName("language")
    private Integer language;
    /**
     * 纯文本释义
     * <p> 示例值：词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通
     */
    @SerializedName("description")
    private String description;
    /**
     * 富文本描述
     * <p> 示例值：<p><span>词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通</span></p>
     */
    @SerializedName("rich_text")
    private String richText;

    // builder 开始
    public I18nEntryDesc() {
    }

    public I18nEntryDesc(Builder builder) {
        /**
         * 语言类型
         * <p> 示例值：1
         */
        this.language = builder.language;
        /**
         * 纯文本释义
         * <p> 示例值：词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通
         */
        this.description = builder.description;
        /**
         * 富文本描述
         * <p> 示例值：<p><span>词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通</span></p>
         */
        this.richText = builder.richText;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getLanguage() {
        return this.language;
    }

    public void setLanguage(Integer language) {
        this.language = language;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRichText() {
        return this.richText;
    }

    public void setRichText(String richText) {
        this.richText = richText;
    }

    public static class Builder {
        /**
         * 语言类型
         * <p> 示例值：1
         */
        private Integer language;
        /**
         * 纯文本释义
         * <p> 示例值：词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通
         */
        private String description;
        /**
         * 富文本描述
         * <p> 示例值：<p><span>词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通</span></p>
         */
        private String richText;

        /**
         * 语言类型
         * <p> 示例值：1
         *
         * @param language
         * @return
         */
        public Builder language(Integer language) {
            this.language = language;
            return this;
        }

        /**
         * 语言类型
         * <p> 示例值：1
         *
         * @param language {@link com.lark.oapi.service.lingo.v1.enums.I18nEntryDescLanguageEnum}
         * @return
         */
        public Builder language(com.lark.oapi.service.lingo.v1.enums.I18nEntryDescLanguageEnum language) {
            this.language = language.getValue();
            return this;
        }


        /**
         * 纯文本释义
         * <p> 示例值：词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通
         *
         * @param description
         * @return
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }


        /**
         * 富文本描述
         * <p> 示例值：<p><span>词典是飞书提供的一款知识管理工具，通过飞书词典可以帮助企业将分散的知识信息进行聚合，并通过UGC的方式，促进企业知识的保鲜和流通</span></p>
         *
         * @param richText
         * @return
         */
        public Builder richText(String richText) {
            this.richText = richText;
            return this;
        }


        public I18nEntryDesc build() {
            return new I18nEntryDesc(this);
        }
    }
}
