// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.security_and_compliance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class VaultExportFile {
    /**
     * 文件名
     * <p> 示例值：
     */
    @SerializedName("name")
    private String name;
    /**
     * 文件大小
     * <p> 示例值：
     */
    @SerializedName("size")
    private String size;
    /**
     * 文件tos uri
     * <p> 示例值：
     */
    @SerializedName("url")
    private String url;
    /**
     * 文件下载的链接(临时链接，数分钟后失效)
     * <p> 示例值：
     */
    @SerializedName("download_url")
    private String downloadUrl;

    // builder 开始
    public VaultExportFile() {
    }

    public VaultExportFile(Builder builder) {
        /**
         * 文件名
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 文件大小
         * <p> 示例值：
         */
        this.size = builder.size;
        /**
         * 文件tos uri
         * <p> 示例值：
         */
        this.url = builder.url;
        /**
         * 文件下载的链接(临时链接，数分钟后失效)
         * <p> 示例值：
         */
        this.downloadUrl = builder.downloadUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public static class Builder {
        /**
         * 文件名
         * <p> 示例值：
         */
        private String name;
        /**
         * 文件大小
         * <p> 示例值：
         */
        private String size;
        /**
         * 文件tos uri
         * <p> 示例值：
         */
        private String url;
        /**
         * 文件下载的链接(临时链接，数分钟后失效)
         * <p> 示例值：
         */
        private String downloadUrl;

        /**
         * 文件名
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 文件大小
         * <p> 示例值：
         *
         * @param size
         * @return
         */
        public Builder size(String size) {
            this.size = size;
            return this;
        }


        /**
         * 文件tos uri
         * <p> 示例值：
         *
         * @param url
         * @return
         */
        public Builder url(String url) {
            this.url = url;
            return this;
        }


        /**
         * 文件下载的链接(临时链接，数分钟后失效)
         * <p> 示例值：
         *
         * @param downloadUrl
         * @return
         */
        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }


        public VaultExportFile build() {
            return new VaultExportFile(this);
        }
    }
}
