// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.bitable.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class DeleteAppRoleMemberReq {
    /**
     * 协作者id类型，与请求体中的member_id要对应
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("member_id_type")
    private String memberIdType;
    /**
     * bitable app token
     * <p> 示例值：appbcbWCzen6D8dezhoCH2RpMAh
     */
    @Path
    @SerializedName("app_token")
    private String appToken;
    /**
     * 自定义角色的id
     * <p> 示例值：roljRpwIUt
     */
    @Path
    @SerializedName("role_id")
    private String roleId;
    /**
     * 协作者id
     * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad53uew2
     */
    @Path
    @SerializedName("member_id")
    private String memberId;
    // builder 开始
    public DeleteAppRoleMemberReq() {
    }
    public DeleteAppRoleMemberReq(Builder builder) {
        /**
         * 协作者id类型，与请求体中的member_id要对应
         * <p> 示例值：open_id
         */
        this.memberIdType = builder.memberIdType;
        /**
         * bitable app token
         * <p> 示例值：appbcbWCzen6D8dezhoCH2RpMAh
         */
        this.appToken = builder.appToken;
        /**
         * 自定义角色的id
         * <p> 示例值：roljRpwIUt
         */
        this.roleId = builder.roleId;
        /**
         * 协作者id
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad53uew2
         */
        this.memberId = builder.memberId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMemberIdType() {
        return this.memberIdType;
    }

    public void setMemberIdType(String memberIdType) {
        this.memberIdType = memberIdType;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public static class Builder {
        private String memberIdType; // 协作者id类型，与请求体中的member_id要对应
        private String appToken; // bitable app token
        private String roleId; // 自定义角色的id
        private String memberId; // 协作者id

        /**
         * 协作者id类型，与请求体中的member_id要对应
         * <p> 示例值：open_id
         *
         * @param memberIdType
         * @return
         */
        public Builder memberIdType(String memberIdType) {
            this.memberIdType = memberIdType;
            return this;
        }

        /**
         * 协作者id类型，与请求体中的member_id要对应
         * <p> 示例值：open_id
         *
         * @param memberIdType {@link com.lark.oapi.service.bitable.v1.enums.DeleteAppRoleMemberMemberIdTypeEnum}
         * @return
         */
        public Builder memberIdType(com.lark.oapi.service.bitable.v1.enums.DeleteAppRoleMemberMemberIdTypeEnum memberIdType) {
            this.memberIdType = memberIdType.getValue();
            return this;
        }

        /**
         * bitable app token
         * <p> 示例值：appbcbWCzen6D8dezhoCH2RpMAh
         *
         * @param appToken
         * @return
         */
        public Builder appToken(String appToken) {
            this.appToken = appToken;
            return this;
        }


        /**
         * 自定义角色的id
         * <p> 示例值：roljRpwIUt
         *
         * @param roleId
         * @return
         */
        public Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }


        /**
         * 协作者id
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad53uew2
         *
         * @param memberId
         * @return
         */
        public Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }


        public DeleteAppRoleMemberReq build() {
            return new DeleteAppRoleMemberReq(this);
        }
    }
}
