// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.cardkit.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.cardkit.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Card {
    /**
     * 卡片数据的类型
     * <p> 示例值：card_json
     */
    @SerializedName("type")
    private String type;
    /**
     * 卡片数据内容，与卡片数据的类型相对应
     * <p> 示例值：{\"schema\":\"2.0\",\"header\":{\"title\":{\"content\":\"卡片标题\",\"tag\":\"plain_text\"}},\"body\":{\"elements\":[{\"tag\":\"markdown\",\"content\":\"卡片内容\"}]}}
     */
    @SerializedName("data")
    private String data;

    // builder 开始
    public Card() {
    }

    public Card(Builder builder) {
        /**
         * 卡片数据的类型
         * <p> 示例值：card_json
         */
        this.type = builder.type;
        /**
         * 卡片数据内容，与卡片数据的类型相对应
         * <p> 示例值：{\"schema\":\"2.0\",\"header\":{\"title\":{\"content\":\"卡片标题\",\"tag\":\"plain_text\"}},\"body\":{\"elements\":[{\"tag\":\"markdown\",\"content\":\"卡片内容\"}]}}
         */
        this.data = builder.data;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public static class Builder {
        /**
         * 卡片数据的类型
         * <p> 示例值：card_json
         */
        private String type;
        /**
         * 卡片数据内容，与卡片数据的类型相对应
         * <p> 示例值：{\"schema\":\"2.0\",\"header\":{\"title\":{\"content\":\"卡片标题\",\"tag\":\"plain_text\"}},\"body\":{\"elements\":[{\"tag\":\"markdown\",\"content\":\"卡片内容\"}]}}
         */
        private String data;

        /**
         * 卡片数据的类型
         * <p> 示例值：card_json
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        /**
         * 卡片数据的类型
         * <p> 示例值：card_json
         *
         * @param type {@link com.lark.oapi.service.cardkit.v1.enums.CardTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.cardkit.v1.enums.CardTypeEnum type) {
            this.type = type.getValue();
            return this;
        }


        /**
         * 卡片数据内容，与卡片数据的类型相对应
         * <p> 示例值：{\"schema\":\"2.0\",\"header\":{\"title\":{\"content\":\"卡片标题\",\"tag\":\"plain_text\"}},\"body\":{\"elements\":[{\"tag\":\"markdown\",\"content\":\"卡片内容\"}]}}
         *
         * @param data
         * @return
         */
        public Builder data(String data) {
            this.data = data;
            return this;
        }


        public Card build() {
            return new Card(this);
        }
    }
}
