// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.task.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.task.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class TaskStatistics {
    /**
     * 任务总数
     * <p> 示例值：12
     */
    @SerializedName("total_tasks_count")
    private Integer totalTasksCount;
    /**
     * 已完成任务的数量
     * <p> 示例值：5
     */
    @SerializedName("total_completed_tasks_count")
    private Integer totalCompletedTasksCount;
    /**
     * 未完成任务的数量
     * <p> 示例值：7
     */
    @SerializedName("total_uncompleted_tasks_count")
    private Integer totalUncompletedTasksCount;

    // builder 开始
    public TaskStatistics() {
    }

    public TaskStatistics(Builder builder) {
        /**
         * 任务总数
         * <p> 示例值：12
         */
        this.totalTasksCount = builder.totalTasksCount;
        /**
         * 已完成任务的数量
         * <p> 示例值：5
         */
        this.totalCompletedTasksCount = builder.totalCompletedTasksCount;
        /**
         * 未完成任务的数量
         * <p> 示例值：7
         */
        this.totalUncompletedTasksCount = builder.totalUncompletedTasksCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getTotalTasksCount() {
        return this.totalTasksCount;
    }

    public void setTotalTasksCount(Integer totalTasksCount) {
        this.totalTasksCount = totalTasksCount;
    }

    public Integer getTotalCompletedTasksCount() {
        return this.totalCompletedTasksCount;
    }

    public void setTotalCompletedTasksCount(Integer totalCompletedTasksCount) {
        this.totalCompletedTasksCount = totalCompletedTasksCount;
    }

    public Integer getTotalUncompletedTasksCount() {
        return this.totalUncompletedTasksCount;
    }

    public void setTotalUncompletedTasksCount(Integer totalUncompletedTasksCount) {
        this.totalUncompletedTasksCount = totalUncompletedTasksCount;
    }

    public static class Builder {
        /**
         * 任务总数
         * <p> 示例值：12
         */
        private Integer totalTasksCount;
        /**
         * 已完成任务的数量
         * <p> 示例值：5
         */
        private Integer totalCompletedTasksCount;
        /**
         * 未完成任务的数量
         * <p> 示例值：7
         */
        private Integer totalUncompletedTasksCount;

        /**
         * 任务总数
         * <p> 示例值：12
         *
         * @param totalTasksCount
         * @return
         */
        public Builder totalTasksCount(Integer totalTasksCount) {
            this.totalTasksCount = totalTasksCount;
            return this;
        }


        /**
         * 已完成任务的数量
         * <p> 示例值：5
         *
         * @param totalCompletedTasksCount
         * @return
         */
        public Builder totalCompletedTasksCount(Integer totalCompletedTasksCount) {
            this.totalCompletedTasksCount = totalCompletedTasksCount;
            return this;
        }


        /**
         * 未完成任务的数量
         * <p> 示例值：7
         *
         * @param totalUncompletedTasksCount
         * @return
         */
        public Builder totalUncompletedTasksCount(Integer totalUncompletedTasksCount) {
            this.totalUncompletedTasksCount = totalUncompletedTasksCount;
            return this;
        }


        public TaskStatistics build() {
            return new TaskStatistics(this);
        }
    }
}
