// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SearchCostCenterReqBody {
    /**
     * 成本中心ID 列表
     * <p> 示例值：
     */
    @SerializedName("cost_center_id_list")
    private String[] costCenterIdList;
    /**
     * 成长中心名称列表，精确匹配
     * <p> 示例值：
     */
    @SerializedName("name_list")
    private String[] nameList;
    /**
     * 成本中心编码
     * <p> 示例值：MDPD00000023
     */
    @SerializedName("code")
    private String code;
    /**
     * 上级成本中心ID，可用于查询直接下级成本中心
     * <p> 示例值：6862995757234914824
     */
    @SerializedName("parent_cost_center_id")
    private String parentCostCenterId;
    /**
     * 是否获取所有陈本中心版本
     * <p> 示例值：true
     */
    @SerializedName("get_all_version")
    private Boolean getAllVersion;

    // builder 开始
    public SearchCostCenterReqBody() {
    }

    public SearchCostCenterReqBody(Builder builder) {
        /**
         * 成本中心ID 列表
         * <p> 示例值：
         */
        this.costCenterIdList = builder.costCenterIdList;
        /**
         * 成长中心名称列表，精确匹配
         * <p> 示例值：
         */
        this.nameList = builder.nameList;
        /**
         * 成本中心编码
         * <p> 示例值：MDPD00000023
         */
        this.code = builder.code;
        /**
         * 上级成本中心ID，可用于查询直接下级成本中心
         * <p> 示例值：6862995757234914824
         */
        this.parentCostCenterId = builder.parentCostCenterId;
        /**
         * 是否获取所有陈本中心版本
         * <p> 示例值：true
         */
        this.getAllVersion = builder.getAllVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getCostCenterIdList() {
        return this.costCenterIdList;
    }

    public void setCostCenterIdList(String[] costCenterIdList) {
        this.costCenterIdList = costCenterIdList;
    }

    public String[] getNameList() {
        return this.nameList;
    }

    public void setNameList(String[] nameList) {
        this.nameList = nameList;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentCostCenterId() {
        return this.parentCostCenterId;
    }

    public void setParentCostCenterId(String parentCostCenterId) {
        this.parentCostCenterId = parentCostCenterId;
    }

    public Boolean getGetAllVersion() {
        return this.getAllVersion;
    }

    public void setGetAllVersion(Boolean getAllVersion) {
        this.getAllVersion = getAllVersion;
    }

    public static class Builder {
        /**
         * 成本中心ID 列表
         * <p> 示例值：
         */
        private String[] costCenterIdList;
        /**
         * 成长中心名称列表，精确匹配
         * <p> 示例值：
         */
        private String[] nameList;
        /**
         * 成本中心编码
         * <p> 示例值：MDPD00000023
         */
        private String code;
        /**
         * 上级成本中心ID，可用于查询直接下级成本中心
         * <p> 示例值：6862995757234914824
         */
        private String parentCostCenterId;
        /**
         * 是否获取所有陈本中心版本
         * <p> 示例值：true
         */
        private Boolean getAllVersion;

        /**
         * 成本中心ID 列表
         * <p> 示例值：
         *
         * @param costCenterIdList
         * @return
         */
        public Builder costCenterIdList(String[] costCenterIdList) {
            this.costCenterIdList = costCenterIdList;
            return this;
        }


        /**
         * 成长中心名称列表，精确匹配
         * <p> 示例值：
         *
         * @param nameList
         * @return
         */
        public Builder nameList(String[] nameList) {
            this.nameList = nameList;
            return this;
        }


        /**
         * 成本中心编码
         * <p> 示例值：MDPD00000023
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 上级成本中心ID，可用于查询直接下级成本中心
         * <p> 示例值：6862995757234914824
         *
         * @param parentCostCenterId
         * @return
         */
        public Builder parentCostCenterId(String parentCostCenterId) {
            this.parentCostCenterId = parentCostCenterId;
            return this;
        }


        /**
         * 是否获取所有陈本中心版本
         * <p> 示例值：true
         *
         * @param getAllVersion
         * @return
         */
        public Builder getAllVersion(Boolean getAllVersion) {
            this.getAllVersion = getAllVersion;
            return this;
        }


        public SearchCostCenterReqBody build() {
            return new SearchCostCenterReqBody(this);
        }
    }
}
