// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.acs.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.acs.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Property {
    /**
     * 设备版本号
     * <p> 示例值：2.3.10
     */
    @SerializedName("version")
    private String version;
    /**
     * 当前设备人脸数量
     * <p> 示例值：300
     */
    @SerializedName("current_device_face_count")
    private Integer currentDeviceFaceCount;
    /**
     * 设备最大人脸容量
     * <p> 示例值：5000
     */
    @SerializedName("max_face_capacity")
    private Integer maxFaceCapacity;
    /**
     * 在线状态
     * <p> 示例值：1
     */
    @SerializedName("online_status")
    private Integer onlineStatus;
    /**
     * 设备名称
     * <p> 示例值：南门
     */
    @SerializedName("device_name")
    private String deviceName;
    /**
     * 是否是打卡
     * <p> 示例值：true
     */
    @SerializedName("is_clock_in")
    private Boolean isClockIn;

    // builder 开始
    public Property() {
    }

    public Property(Builder builder) {
        /**
         * 设备版本号
         * <p> 示例值：2.3.10
         */
        this.version = builder.version;
        /**
         * 当前设备人脸数量
         * <p> 示例值：300
         */
        this.currentDeviceFaceCount = builder.currentDeviceFaceCount;
        /**
         * 设备最大人脸容量
         * <p> 示例值：5000
         */
        this.maxFaceCapacity = builder.maxFaceCapacity;
        /**
         * 在线状态
         * <p> 示例值：1
         */
        this.onlineStatus = builder.onlineStatus;
        /**
         * 设备名称
         * <p> 示例值：南门
         */
        this.deviceName = builder.deviceName;
        /**
         * 是否是打卡
         * <p> 示例值：true
         */
        this.isClockIn = builder.isClockIn;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getCurrentDeviceFaceCount() {
        return this.currentDeviceFaceCount;
    }

    public void setCurrentDeviceFaceCount(Integer currentDeviceFaceCount) {
        this.currentDeviceFaceCount = currentDeviceFaceCount;
    }

    public Integer getMaxFaceCapacity() {
        return this.maxFaceCapacity;
    }

    public void setMaxFaceCapacity(Integer maxFaceCapacity) {
        this.maxFaceCapacity = maxFaceCapacity;
    }

    public Integer getOnlineStatus() {
        return this.onlineStatus;
    }

    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Boolean getIsClockIn() {
        return this.isClockIn;
    }

    public void setIsClockIn(Boolean isClockIn) {
        this.isClockIn = isClockIn;
    }

    public static class Builder {
        /**
         * 设备版本号
         * <p> 示例值：2.3.10
         */
        private String version;
        /**
         * 当前设备人脸数量
         * <p> 示例值：300
         */
        private Integer currentDeviceFaceCount;
        /**
         * 设备最大人脸容量
         * <p> 示例值：5000
         */
        private Integer maxFaceCapacity;
        /**
         * 在线状态
         * <p> 示例值：1
         */
        private Integer onlineStatus;
        /**
         * 设备名称
         * <p> 示例值：南门
         */
        private String deviceName;
        /**
         * 是否是打卡
         * <p> 示例值：true
         */
        private Boolean isClockIn;

        /**
         * 设备版本号
         * <p> 示例值：2.3.10
         *
         * @param version
         * @return
         */
        public Builder version(String version) {
            this.version = version;
            return this;
        }


        /**
         * 当前设备人脸数量
         * <p> 示例值：300
         *
         * @param currentDeviceFaceCount
         * @return
         */
        public Builder currentDeviceFaceCount(Integer currentDeviceFaceCount) {
            this.currentDeviceFaceCount = currentDeviceFaceCount;
            return this;
        }


        /**
         * 设备最大人脸容量
         * <p> 示例值：5000
         *
         * @param maxFaceCapacity
         * @return
         */
        public Builder maxFaceCapacity(Integer maxFaceCapacity) {
            this.maxFaceCapacity = maxFaceCapacity;
            return this;
        }


        /**
         * 在线状态
         * <p> 示例值：1
         *
         * @param onlineStatus
         * @return
         */
        public Builder onlineStatus(Integer onlineStatus) {
            this.onlineStatus = onlineStatus;
            return this;
        }

        /**
         * 在线状态
         * <p> 示例值：1
         *
         * @param onlineStatus {@link com.lark.oapi.service.acs.v1.enums.PropertyOnlineStatusEnum}
         * @return
         */
        public Builder onlineStatus(com.lark.oapi.service.acs.v1.enums.PropertyOnlineStatusEnum onlineStatus) {
            this.onlineStatus = onlineStatus.getValue();
            return this;
        }


        /**
         * 设备名称
         * <p> 示例值：南门
         *
         * @param deviceName
         * @return
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }


        /**
         * 是否是打卡
         * <p> 示例值：true
         *
         * @param isClockIn
         * @return
         */
        public Builder isClockIn(Boolean isClockIn) {
            this.isClockIn = isClockIn;
            return this;
        }


        public Property build() {
            return new Property(this);
        }
    }
}
