// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class GetLeaveEmployExpireRecordReq {
    /**
     * 用户 ID 类型
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 假期类型ID
     * <p> 示例值：1
     */
    @Path
    @SerializedName("leave_id")
    private String leaveId;
    @Body
    private GetLeaveEmployExpireRecordReqBody body;

    // builder 开始
    public GetLeaveEmployExpireRecordReq() {
    }

    public GetLeaveEmployExpireRecordReq(Builder builder) {
        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 假期类型ID
         * <p> 示例值：1
         */
        this.leaveId = builder.leaveId;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getLeaveId() {
        return this.leaveId;
    }

    public void setLeaveId(String leaveId) {
        this.leaveId = leaveId;
    }

    public GetLeaveEmployExpireRecordReqBody getGetLeaveEmployExpireRecordReqBody() {
        return this.body;
    }

    public void setGetLeaveEmployExpireRecordReqBody(GetLeaveEmployExpireRecordReqBody body) {
        this.body = body;
    }

    public static class Builder {
        private String userIdType; // 用户 ID 类型
        private String leaveId; // 假期类型ID
        private GetLeaveEmployExpireRecordReqBody body;

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         *
         * @param userIdType {@link com.lark.oapi.service.attendance.v1.enums.GetLeaveEmployExpireRecordUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.attendance.v1.enums.GetLeaveEmployExpireRecordUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        /**
         * 假期类型ID
         * <p> 示例值：1
         *
         * @param leaveId
         * @return
         */
        public Builder leaveId(String leaveId) {
            this.leaveId = leaveId;
            return this;
        }

        public GetLeaveEmployExpireRecordReqBody getGetLeaveEmployExpireRecordReqBody() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder getLeaveEmployExpireRecordReqBody(GetLeaveEmployExpireRecordReqBody body) {
            this.body = body;
            return this;
        }

        public GetLeaveEmployExpireRecordReq build() {
            return new GetLeaveEmployExpireRecordReq(this);
        }
    }
}
