// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.calendar.v4.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class EventCheckIn {
    /**
     * 是否启用日程签到
     * <p> 示例值：
     */
    @SerializedName("enable_check_in")
    private Boolean enableCheckIn;
    /**
     * 日程签到开始时间
     * <p> 示例值：
     */
    @SerializedName("check_in_start_time")
    private CheckInTime checkInStartTime;
    /**
     * 日程签到结束时间
     * <p> 示例值：
     */
    @SerializedName("check_in_end_time")
    private CheckInTime checkInEndTime;
    /**
     * 签到开始时是否自动发送签到通知给参与者
     * <p> 示例值：
     */
    @SerializedName("need_notify_attendees")
    private Boolean needNotifyAttendees;

    // builder 开始
    public EventCheckIn() {
    }

    public EventCheckIn(Builder builder) {
        /**
         * 是否启用日程签到
         * <p> 示例值：
         */
        this.enableCheckIn = builder.enableCheckIn;
        /**
         * 日程签到开始时间
         * <p> 示例值：
         */
        this.checkInStartTime = builder.checkInStartTime;
        /**
         * 日程签到结束时间
         * <p> 示例值：
         */
        this.checkInEndTime = builder.checkInEndTime;
        /**
         * 签到开始时是否自动发送签到通知给参与者
         * <p> 示例值：
         */
        this.needNotifyAttendees = builder.needNotifyAttendees;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Boolean getEnableCheckIn() {
        return this.enableCheckIn;
    }

    public void setEnableCheckIn(Boolean enableCheckIn) {
        this.enableCheckIn = enableCheckIn;
    }

    public CheckInTime getCheckInStartTime() {
        return this.checkInStartTime;
    }

    public void setCheckInStartTime(CheckInTime checkInStartTime) {
        this.checkInStartTime = checkInStartTime;
    }

    public CheckInTime getCheckInEndTime() {
        return this.checkInEndTime;
    }

    public void setCheckInEndTime(CheckInTime checkInEndTime) {
        this.checkInEndTime = checkInEndTime;
    }

    public Boolean getNeedNotifyAttendees() {
        return this.needNotifyAttendees;
    }

    public void setNeedNotifyAttendees(Boolean needNotifyAttendees) {
        this.needNotifyAttendees = needNotifyAttendees;
    }

    public static class Builder {
        /**
         * 是否启用日程签到
         * <p> 示例值：
         */
        private Boolean enableCheckIn;
        /**
         * 日程签到开始时间
         * <p> 示例值：
         */
        private CheckInTime checkInStartTime;
        /**
         * 日程签到结束时间
         * <p> 示例值：
         */
        private CheckInTime checkInEndTime;
        /**
         * 签到开始时是否自动发送签到通知给参与者
         * <p> 示例值：
         */
        private Boolean needNotifyAttendees;

        /**
         * 是否启用日程签到
         * <p> 示例值：
         *
         * @param enableCheckIn
         * @return
         */
        public Builder enableCheckIn(Boolean enableCheckIn) {
            this.enableCheckIn = enableCheckIn;
            return this;
        }


        /**
         * 日程签到开始时间
         * <p> 示例值：
         *
         * @param checkInStartTime
         * @return
         */
        public Builder checkInStartTime(CheckInTime checkInStartTime) {
            this.checkInStartTime = checkInStartTime;
            return this;
        }


        /**
         * 日程签到结束时间
         * <p> 示例值：
         *
         * @param checkInEndTime
         * @return
         */
        public Builder checkInEndTime(CheckInTime checkInEndTime) {
            this.checkInEndTime = checkInEndTime;
            return this;
        }


        /**
         * 签到开始时是否自动发送签到通知给参与者
         * <p> 示例值：
         *
         * @param needNotifyAttendees
         * @return
         */
        public Builder needNotifyAttendees(Boolean needNotifyAttendees) {
            this.needNotifyAttendees = needNotifyAttendees;
            return this;
        }


        public EventCheckIn build() {
            return new EventCheckIn(this);
        }
    }
}
