// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.search.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class TimeRange {
    /**
     * 时间范围的起始时间戳
     * <p> 示例值：123345
     */
    @SerializedName("start")
    private Integer start;
    /**
     * 时间范围的截止时间戳
     * <p> 示例值：123456
     */
    @SerializedName("end")
    private Integer end;

    // builder 开始
    public TimeRange() {
    }

    public TimeRange(Builder builder) {
        /**
         * 时间范围的起始时间戳
         * <p> 示例值：123345
         */
        this.start = builder.start;
        /**
         * 时间范围的截止时间戳
         * <p> 示例值：123456
         */
        this.end = builder.end;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public static class Builder {
        /**
         * 时间范围的起始时间戳
         * <p> 示例值：123345
         */
        private Integer start;
        /**
         * 时间范围的截止时间戳
         * <p> 示例值：123456
         */
        private Integer end;

        /**
         * 时间范围的起始时间戳
         * <p> 示例值：123345
         *
         * @param start
         * @return
         */
        public Builder start(Integer start) {
            this.start = start;
            return this;
        }


        /**
         * 时间范围的截止时间戳
         * <p> 示例值：123456
         *
         * @param end
         * @return
         */
        public Builder end(Integer end) {
            this.end = end;
            return this;
        }


        public TimeRange build() {
            return new TimeRange(this);
        }
    }
}
