/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.document_ai.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.service.document_ai.v1.enums.LlmConfigMessageTypeEnum;
import com.lark.oapi.service.document_ai.v1.enums.LlmConfigModelEnum;
import com.lark.oapi.service.document_ai.v1.model.LlmMessage;

public class LlmConfig {
    @SerializedName(value="model")
    private String model;
    @SerializedName(value="messages")
    private LlmMessage[] messages;
    @SerializedName(value="max_tokens")
    private Integer maxTokens;
    @SerializedName(value="message_type")
    private String messageType;
    @SerializedName(value="n")
    private Integer n;
    @SerializedName(value="temperature")
    private Double temperature;
    @SerializedName(value="presence_penalty")
    private Double presencePenalty;
    @SerializedName(value="frequency_penalty")
    private Double frequencyPenalty;

    public LlmConfig() {
    }

    public LlmConfig(Builder builder) {
        this.model = builder.model;
        this.messages = builder.messages;
        this.maxTokens = builder.maxTokens;
        this.messageType = builder.messageType;
        this.n = builder.n;
        this.temperature = builder.temperature;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public LlmMessage[] getMessages() {
        return this.messages;
    }

    public void setMessages(LlmMessage[] messages) {
        this.messages = messages;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public static class Builder {
        private String model;
        private LlmMessage[] messages;
        private Integer maxTokens;
        private String messageType;
        private Integer n;
        private Double temperature;
        private Double presencePenalty;
        private Double frequencyPenalty;

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(LlmConfigModelEnum model) {
            this.model = model.getValue();
            return this;
        }

        public Builder messages(LlmMessage[] messages) {
            this.messages = messages;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder messageType(LlmConfigMessageTypeEnum messageType) {
            this.messageType = messageType.getValue();
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public LlmConfig build() {
            return new LlmConfig(this);
        }
    }
}

