// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.compensation.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.compensation.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ArchiveItemValue {
    /**
     * 薪资项ID
     * <p> 示例值：7244131355509917228
     */
    @SerializedName("item_id")
    private String itemId;
    /**
     * 薪资项的值
     * <p> 示例值：200.00
     */
    @SerializedName("item_value")
    private String itemValue;
    /**
     * 员工转正后薪资项的值，仅用于开启试用期的薪资方案，以及员工处于实习期
     * <p> 示例值：600.00
     */
    @SerializedName("item_value_regular")
    private String itemValueRegular;

    // builder 开始
    public ArchiveItemValue() {
    }

    public ArchiveItemValue(Builder builder) {
        /**
         * 薪资项ID
         * <p> 示例值：7244131355509917228
         */
        this.itemId = builder.itemId;
        /**
         * 薪资项的值
         * <p> 示例值：200.00
         */
        this.itemValue = builder.itemValue;
        /**
         * 员工转正后薪资项的值，仅用于开启试用期的薪资方案，以及员工处于实习期
         * <p> 示例值：600.00
         */
        this.itemValueRegular = builder.itemValueRegular;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemValue() {
        return this.itemValue;
    }

    public void setItemValue(String itemValue) {
        this.itemValue = itemValue;
    }

    public String getItemValueRegular() {
        return this.itemValueRegular;
    }

    public void setItemValueRegular(String itemValueRegular) {
        this.itemValueRegular = itemValueRegular;
    }

    public static class Builder {
        /**
         * 薪资项ID
         * <p> 示例值：7244131355509917228
         */
        private String itemId;
        /**
         * 薪资项的值
         * <p> 示例值：200.00
         */
        private String itemValue;
        /**
         * 员工转正后薪资项的值，仅用于开启试用期的薪资方案，以及员工处于实习期
         * <p> 示例值：600.00
         */
        private String itemValueRegular;

        /**
         * 薪资项ID
         * <p> 示例值：7244131355509917228
         *
         * @param itemId
         * @return
         */
        public Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }


        /**
         * 薪资项的值
         * <p> 示例值：200.00
         *
         * @param itemValue
         * @return
         */
        public Builder itemValue(String itemValue) {
            this.itemValue = itemValue;
            return this;
        }


        /**
         * 员工转正后薪资项的值，仅用于开启试用期的薪资方案，以及员工处于实习期
         * <p> 示例值：600.00
         *
         * @param itemValueRegular
         * @return
         */
        public Builder itemValueRegular(String itemValueRegular) {
            this.itemValueRegular = itemValueRegular;
            return this;
        }


        public ArchiveItemValue build() {
            return new ArchiveItemValue(this);
        }
    }
}
