// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CalendarDateByDateFilter {
    /**
     * 工作日历WKID列表，最多100
     * <p> 示例值："7390282135276635692"
     */
    @SerializedName("wk_calendar_ids")
    private String[] wkCalendarIds;
    /**
     * 日期，格式："2006-01-02"，最多50个
     * <p> 示例值：
     */
    @SerializedName("dates")
    private String[] dates;
    /**
     * 日期范围-开始日期，格式："2006-01-02"
     * <p> 示例值："2006-01-02"
     */
    @SerializedName("begin_date")
    private String beginDate;
    /**
     * 日期范围-结束日期(含)，格式："2006-01-02"
     * <p> 示例值："2006-01-02"
     */
    @SerializedName("end_date")
    private String endDate;
    /**
     * 分页
     * <p> 示例值：0
     */
    @SerializedName("offset")
    private Integer offset;
    /**
     * 分页大小
     * <p> 示例值：10
     */
    @SerializedName("limit")
    private Integer limit;
    /**
     * 日期id，与其他筛选参数互斥，传了该参数，其他筛选参数不起效
     * <p> 示例值：
     */
    @SerializedName("ids")
    private String[] ids;

    // builder 开始
    public CalendarDateByDateFilter() {
    }

    public CalendarDateByDateFilter(Builder builder) {
        /**
         * 工作日历WKID列表，最多100
         * <p> 示例值："7390282135276635692"
         */
        this.wkCalendarIds = builder.wkCalendarIds;
        /**
         * 日期，格式："2006-01-02"，最多50个
         * <p> 示例值：
         */
        this.dates = builder.dates;
        /**
         * 日期范围-开始日期，格式："2006-01-02"
         * <p> 示例值："2006-01-02"
         */
        this.beginDate = builder.beginDate;
        /**
         * 日期范围-结束日期(含)，格式："2006-01-02"
         * <p> 示例值："2006-01-02"
         */
        this.endDate = builder.endDate;
        /**
         * 分页
         * <p> 示例值：0
         */
        this.offset = builder.offset;
        /**
         * 分页大小
         * <p> 示例值：10
         */
        this.limit = builder.limit;
        /**
         * 日期id，与其他筛选参数互斥，传了该参数，其他筛选参数不起效
         * <p> 示例值：
         */
        this.ids = builder.ids;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getWkCalendarIds() {
        return this.wkCalendarIds;
    }

    public void setWkCalendarIds(String[] wkCalendarIds) {
        this.wkCalendarIds = wkCalendarIds;
    }

    public String[] getDates() {
        return this.dates;
    }

    public void setDates(String[] dates) {
        this.dates = dates;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public static class Builder {
        /**
         * 工作日历WKID列表，最多100
         * <p> 示例值："7390282135276635692"
         */
        private String[] wkCalendarIds;
        /**
         * 日期，格式："2006-01-02"，最多50个
         * <p> 示例值：
         */
        private String[] dates;
        /**
         * 日期范围-开始日期，格式："2006-01-02"
         * <p> 示例值："2006-01-02"
         */
        private String beginDate;
        /**
         * 日期范围-结束日期(含)，格式："2006-01-02"
         * <p> 示例值："2006-01-02"
         */
        private String endDate;
        /**
         * 分页
         * <p> 示例值：0
         */
        private Integer offset;
        /**
         * 分页大小
         * <p> 示例值：10
         */
        private Integer limit;
        /**
         * 日期id，与其他筛选参数互斥，传了该参数，其他筛选参数不起效
         * <p> 示例值：
         */
        private String[] ids;

        /**
         * 工作日历WKID列表，最多100
         * <p> 示例值："7390282135276635692"
         *
         * @param wkCalendarIds
         * @return
         */
        public Builder wkCalendarIds(String[] wkCalendarIds) {
            this.wkCalendarIds = wkCalendarIds;
            return this;
        }


        /**
         * 日期，格式："2006-01-02"，最多50个
         * <p> 示例值：
         *
         * @param dates
         * @return
         */
        public Builder dates(String[] dates) {
            this.dates = dates;
            return this;
        }


        /**
         * 日期范围-开始日期，格式："2006-01-02"
         * <p> 示例值："2006-01-02"
         *
         * @param beginDate
         * @return
         */
        public Builder beginDate(String beginDate) {
            this.beginDate = beginDate;
            return this;
        }


        /**
         * 日期范围-结束日期(含)，格式："2006-01-02"
         * <p> 示例值："2006-01-02"
         *
         * @param endDate
         * @return
         */
        public Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }


        /**
         * 分页
         * <p> 示例值：0
         *
         * @param offset
         * @return
         */
        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }


        /**
         * 分页大小
         * <p> 示例值：10
         *
         * @param limit
         * @return
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }


        /**
         * 日期id，与其他筛选参数互斥，传了该参数，其他筛选参数不起效
         * <p> 示例值：
         *
         * @param ids
         * @return
         */
        public Builder ids(String[] ids) {
            this.ids = ids;
            return this;
        }


        public CalendarDateByDateFilter build() {
            return new CalendarDateByDateFilter(this);
        }
    }
}
