// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class EmergencyContactForUpdate {
    /**
     * 紧急联系人姓名
     * <p> 示例值：王冰
     */
    @SerializedName("legal_name")
    private String legalName;
    /**
     * 紧急联系人与本人亲属关系，枚举值可查询【获取字段详情】接口获取，按如下参数查询即可：- object_api_name = "emergency_contact" - custom_api_name = "relationship"
     * <p> 示例值：x
     */
    @SerializedName("relationship")
    private String relationship;
    /**
     * 电话
     * <p> 示例值：
     */
    @SerializedName("phones")
    private PhoneForUpdate[] phones;
    /**
     * 地址
     * <p> 示例值：
     */
    @SerializedName("address")
    private AddressForUpdate address;
    /**
     * 邮箱
     * <p> 示例值：
     */
    @SerializedName("email")
    private EmailForUpdate email;
    /**
     * 主要联系人,若有多个联系人，只能有一个联系人的「is_primary」为true
     * <p> 示例值：true
     */
    @SerializedName("is_primary")
    private Boolean isPrimary;
    /**
     * 自定义字段
     * <p> 示例值：
     */
    @SerializedName("custom_fields")
    private ObjectFieldData[] customFields;

    // builder 开始
    public EmergencyContactForUpdate() {
    }

    public EmergencyContactForUpdate(Builder builder) {
        /**
         * 紧急联系人姓名
         * <p> 示例值：王冰
         */
        this.legalName = builder.legalName;
        /**
         * 紧急联系人与本人亲属关系，枚举值可查询【获取字段详情】接口获取，按如下参数查询即可：- object_api_name = "emergency_contact" - custom_api_name = "relationship"
         * <p> 示例值：x
         */
        this.relationship = builder.relationship;
        /**
         * 电话
         * <p> 示例值：
         */
        this.phones = builder.phones;
        /**
         * 地址
         * <p> 示例值：
         */
        this.address = builder.address;
        /**
         * 邮箱
         * <p> 示例值：
         */
        this.email = builder.email;
        /**
         * 主要联系人,若有多个联系人，只能有一个联系人的「is_primary」为true
         * <p> 示例值：true
         */
        this.isPrimary = builder.isPrimary;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        this.customFields = builder.customFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public PhoneForUpdate[] getPhones() {
        return this.phones;
    }

    public void setPhones(PhoneForUpdate[] phones) {
        this.phones = phones;
    }

    public AddressForUpdate getAddress() {
        return this.address;
    }

    public void setAddress(AddressForUpdate address) {
        this.address = address;
    }

    public EmailForUpdate getEmail() {
        return this.email;
    }

    public void setEmail(EmailForUpdate email) {
        this.email = email;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public ObjectFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ObjectFieldData[] customFields) {
        this.customFields = customFields;
    }

    public static class Builder {
        /**
         * 紧急联系人姓名
         * <p> 示例值：王冰
         */
        private String legalName;
        /**
         * 紧急联系人与本人亲属关系，枚举值可查询【获取字段详情】接口获取，按如下参数查询即可：- object_api_name = "emergency_contact" - custom_api_name = "relationship"
         * <p> 示例值：x
         */
        private String relationship;
        /**
         * 电话
         * <p> 示例值：
         */
        private PhoneForUpdate[] phones;
        /**
         * 地址
         * <p> 示例值：
         */
        private AddressForUpdate address;
        /**
         * 邮箱
         * <p> 示例值：
         */
        private EmailForUpdate email;
        /**
         * 主要联系人,若有多个联系人，只能有一个联系人的「is_primary」为true
         * <p> 示例值：true
         */
        private Boolean isPrimary;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        private ObjectFieldData[] customFields;

        /**
         * 紧急联系人姓名
         * <p> 示例值：王冰
         *
         * @param legalName
         * @return
         */
        public Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }


        /**
         * 紧急联系人与本人亲属关系，枚举值可查询【获取字段详情】接口获取，按如下参数查询即可：- object_api_name = "emergency_contact" - custom_api_name = "relationship"
         * <p> 示例值：x
         *
         * @param relationship
         * @return
         */
        public Builder relationship(String relationship) {
            this.relationship = relationship;
            return this;
        }


        /**
         * 电话
         * <p> 示例值：
         *
         * @param phones
         * @return
         */
        public Builder phones(PhoneForUpdate[] phones) {
            this.phones = phones;
            return this;
        }


        /**
         * 地址
         * <p> 示例值：
         *
         * @param address
         * @return
         */
        public Builder address(AddressForUpdate address) {
            this.address = address;
            return this;
        }


        /**
         * 邮箱
         * <p> 示例值：
         *
         * @param email
         * @return
         */
        public Builder email(EmailForUpdate email) {
            this.email = email;
            return this;
        }


        /**
         * 主要联系人,若有多个联系人，只能有一个联系人的「is_primary」为true
         * <p> 示例值：true
         *
         * @param isPrimary
         * @return
         */
        public Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }


        /**
         * 自定义字段
         * <p> 示例值：
         *
         * @param customFields
         * @return
         */
        public Builder customFields(ObjectFieldData[] customFields) {
            this.customFields = customFields;
            return this;
        }


        public EmergencyContactForUpdate build() {
            return new EmergencyContactForUpdate(this);
        }
    }
}
