// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.document_ai.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.document_ai.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class LlmContent {
    /**
     * 内容类型：text, image_zip
     * <p> 示例值：text
     */
    @SerializedName("type")
    private String type;
    /**
     * 内容：text类型就是对应的输入文本， image_zip是文件的相对路径，文件需要以zip格式输入
     * <p> 示例值：输入图片按顺序描述了一件什么事情
     */
    @SerializedName("content")
    private String content;

    // builder 开始
    public LlmContent() {
    }

    public LlmContent(Builder builder) {
        /**
         * 内容类型：text, image_zip
         * <p> 示例值：text
         */
        this.type = builder.type;
        /**
         * 内容：text类型就是对应的输入文本， image_zip是文件的相对路径，文件需要以zip格式输入
         * <p> 示例值：输入图片按顺序描述了一件什么事情
         */
        this.content = builder.content;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static class Builder {
        /**
         * 内容类型：text, image_zip
         * <p> 示例值：text
         */
        private String type;
        /**
         * 内容：text类型就是对应的输入文本， image_zip是文件的相对路径，文件需要以zip格式输入
         * <p> 示例值：输入图片按顺序描述了一件什么事情
         */
        private String content;

        /**
         * 内容类型：text, image_zip
         * <p> 示例值：text
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        /**
         * 内容类型：text, image_zip
         * <p> 示例值：text
         *
         * @param type {@link com.lark.oapi.service.document_ai.v1.enums.LlmContentTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.document_ai.v1.enums.LlmContentTypeEnum type) {
            this.type = type.getValue();
            return this;
        }


        /**
         * 内容：text类型就是对应的输入文本， image_zip是文件的相对路径，文件需要以zip格式输入
         * <p> 示例值：输入图片按顺序描述了一件什么事情
         *
         * @param content
         * @return
         */
        public Builder content(String content) {
            this.content = content;
            return this;
        }


        public LlmContent build() {
            return new LlmContent(this);
        }
    }
}
