// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.helpdesk.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.helpdesk.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CreateTicketMessageReqBody {
    /**
     * 消息类型；text：纯文本；post：富文本
     * <p> 示例值：post
     */
    @SerializedName("msg_type")
    private String msgType;
    /**
     * - 纯文本，参考[发送文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uUjNz4SN2MjL1YzM)中的content；;- 富文本，参考[发送富文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uMDMxEjLzATMx4yMwETM)中的content
     * <p> 示例值：{;    "msg_type": "post",;    "content": {;        "post": {;            "zh_cn": {;                "title": "this is title",;                "content": [;                    [;                        {;                            "tag": "text",;                            "un_escape": true,;                            "text": "第一行&nbsp;:";                        },;                        {;                            "tag": "a",;                            "text": "超链接",;                            "href": "http://www.feishu.cn";                        };                    ],;                    [;                        {;                            "tag": "text",;                            "text": "第二行 :";                        },;                        {;                            "tag": "text",;                            "text": "文本测试";                        };                    ];                ];            };        };    };}
     */
    @SerializedName("content")
    private String content;

    // builder 开始
    public CreateTicketMessageReqBody() {
    }

    public CreateTicketMessageReqBody(Builder builder) {
        /**
         * 消息类型；text：纯文本；post：富文本
         * <p> 示例值：post
         */
        this.msgType = builder.msgType;
        /**
         * - 纯文本，参考[发送文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uUjNz4SN2MjL1YzM)中的content；;- 富文本，参考[发送富文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uMDMxEjLzATMx4yMwETM)中的content
         * <p> 示例值：{;    "msg_type": "post",;    "content": {;        "post": {;            "zh_cn": {;                "title": "this is title",;                "content": [;                    [;                        {;                            "tag": "text",;                            "un_escape": true,;                            "text": "第一行&nbsp;:";                        },;                        {;                            "tag": "a",;                            "text": "超链接",;                            "href": "http://www.feishu.cn";                        };                    ],;                    [;                        {;                            "tag": "text",;                            "text": "第二行 :";                        },;                        {;                            "tag": "text",;                            "text": "文本测试";                        };                    ];                ];            };        };    };}
         */
        this.content = builder.content;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static class Builder {
        /**
         * 消息类型；text：纯文本；post：富文本
         * <p> 示例值：post
         */
        private String msgType;
        /**
         * - 纯文本，参考[发送文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uUjNz4SN2MjL1YzM)中的content；;- 富文本，参考[发送富文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uMDMxEjLzATMx4yMwETM)中的content
         * <p> 示例值：{;    "msg_type": "post",;    "content": {;        "post": {;            "zh_cn": {;                "title": "this is title",;                "content": [;                    [;                        {;                            "tag": "text",;                            "un_escape": true,;                            "text": "第一行&nbsp;:";                        },;                        {;                            "tag": "a",;                            "text": "超链接",;                            "href": "http://www.feishu.cn";                        };                    ],;                    [;                        {;                            "tag": "text",;                            "text": "第二行 :";                        },;                        {;                            "tag": "text",;                            "text": "文本测试";                        };                    ];                ];            };        };    };}
         */
        private String content;

        /**
         * 消息类型；text：纯文本；post：富文本
         * <p> 示例值：post
         *
         * @param msgType
         * @return
         */
        public Builder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }


        /**
         * - 纯文本，参考[发送文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uUjNz4SN2MjL1YzM)中的content；;- 富文本，参考[发送富文本消息](https://open.feishu.cn/document/ukTMukTMukTM/uMDMxEjLzATMx4yMwETM)中的content
         * <p> 示例值：{;    "msg_type": "post",;    "content": {;        "post": {;            "zh_cn": {;                "title": "this is title",;                "content": [;                    [;                        {;                            "tag": "text",;                            "un_escape": true,;                            "text": "第一行&nbsp;:";                        },;                        {;                            "tag": "a",;                            "text": "超链接",;                            "href": "http://www.feishu.cn";                        };                    ],;                    [;                        {;                            "tag": "text",;                            "text": "第二行 :";                        },;                        {;                            "tag": "text",;                            "text": "文本测试";                        };                    ];                ];            };        };    };}
         *
         * @param content
         * @return
         */
        public Builder content(String content) {
            this.content = content;
            return this;
        }


        public CreateTicketMessageReqBody build() {
            return new CreateTicketMessageReqBody(this);
        }
    }
}
