// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mail.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UserInfo {
    /**
     * 个人邮箱还是公共邮箱
     * <p> 示例值：user 或 public_mailbox
     */
    @SerializedName("type")
    private String type;
    /**
     * 卡片owner的ID，卡片owner为个人邮箱时非空
     * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
     */
    @SerializedName("owner_user_id")
    private String ownerUserId;
    /**
     * 公共邮箱唯一标识
     * <p> 示例值：xxxxxxxxxx
     */
    @SerializedName("public_mailbox_id")
    private String publicMailboxId;

    // builder 开始
    public UserInfo() {
    }

    public UserInfo(Builder builder) {
        /**
         * 个人邮箱还是公共邮箱
         * <p> 示例值：user 或 public_mailbox
         */
        this.type = builder.type;
        /**
         * 卡片owner的ID，卡片owner为个人邮箱时非空
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
         */
        this.ownerUserId = builder.ownerUserId;
        /**
         * 公共邮箱唯一标识
         * <p> 示例值：xxxxxxxxxx
         */
        this.publicMailboxId = builder.publicMailboxId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public String getPublicMailboxId() {
        return this.publicMailboxId;
    }

    public void setPublicMailboxId(String publicMailboxId) {
        this.publicMailboxId = publicMailboxId;
    }

    public static class Builder {
        /**
         * 个人邮箱还是公共邮箱
         * <p> 示例值：user 或 public_mailbox
         */
        private String type;
        /**
         * 卡片owner的ID，卡片owner为个人邮箱时非空
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
         */
        private String ownerUserId;
        /**
         * 公共邮箱唯一标识
         * <p> 示例值：xxxxxxxxxx
         */
        private String publicMailboxId;

        /**
         * 个人邮箱还是公共邮箱
         * <p> 示例值：user 或 public_mailbox
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }


        /**
         * 卡片owner的ID，卡片owner为个人邮箱时非空
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
         *
         * @param ownerUserId
         * @return
         */
        public Builder ownerUserId(String ownerUserId) {
            this.ownerUserId = ownerUserId;
            return this;
        }


        /**
         * 公共邮箱唯一标识
         * <p> 示例值：xxxxxxxxxx
         *
         * @param publicMailboxId
         * @return
         */
        public Builder publicMailboxId(String publicMailboxId) {
            this.publicMailboxId = publicMailboxId;
            return this;
        }


        public UserInfo build() {
            return new UserInfo(this);
        }
    }
}
