// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CalendarPeriod {
    /**
     * 计薪周期开始日期
     * <p> 示例值：2022-01-01
     */
    @SerializedName("period_start_date")
    private String periodStartDate;
    /**
     * 计薪周期结束日期
     * <p> 示例值：2022-01-01
     */
    @SerializedName("period_end_date")
    private String periodEndDate;
    /**
     * 计薪周期key
     * <p> 示例值：2022-01
     */
    @SerializedName("period_key")
    private String periodKey;
    /**
     * 计薪周期名称
     * <p> 示例值：
     */
    @SerializedName("period_name")
    private I18n periodName;
    /**
     * 计薪周期类型
     * <p> 示例值：1
     */
    @SerializedName("payroll_cycle")
    private Integer payrollCycle;
    /**
     * 时区
     * <p> 示例值：(GMT+08:00) 中国标准时间 - 上海
     */
    @SerializedName("time_zone")
    private String timeZone;
    /**
     * 发放日期
     * <p> 示例值：2022-01-01
     */
    @SerializedName("pay_date")
    private String payDate;
    /**
     * 关联的算薪日历ID
     * <p> 示例值：7374707723663867948
     */
    @SerializedName("payroll_calendar_id")
    private String payrollCalendarId;
    /**
     * 截止日期
     * <p> 示例值：2022-01-01
     */
    @SerializedName("cut_off_date")
    private String cutOffDate;
    /**
     * 税款所属年月
     * <p> 示例值：2023-10
     */
    @SerializedName("taxable_period")
    private String taxablePeriod;
    /**
     * 是否手动修改过
     * <p> 示例值：
     */
    @SerializedName("manual_modified")
    private Boolean manualModified;
    /**
     * 考勤开始日期
     * <p> 示例值：2024-01-01
     */
    @SerializedName("attendance_start_date")
    private String attendanceStartDate;
    /**
     * 考勤结束日期
     * <p> 示例值：2024-01-31
     */
    @SerializedName("attendance_end_date")
    private String attendanceEndDate;
    /**
     * 名单收集截止日
     * <p> 示例值：2024-01-26
     */
    @SerializedName("cut_off_date_for_paylist")
    private String cutOffDateForPaylist;

    // builder 开始
    public CalendarPeriod() {
    }

    public CalendarPeriod(Builder builder) {
        /**
         * 计薪周期开始日期
         * <p> 示例值：2022-01-01
         */
        this.periodStartDate = builder.periodStartDate;
        /**
         * 计薪周期结束日期
         * <p> 示例值：2022-01-01
         */
        this.periodEndDate = builder.periodEndDate;
        /**
         * 计薪周期key
         * <p> 示例值：2022-01
         */
        this.periodKey = builder.periodKey;
        /**
         * 计薪周期名称
         * <p> 示例值：
         */
        this.periodName = builder.periodName;
        /**
         * 计薪周期类型
         * <p> 示例值：1
         */
        this.payrollCycle = builder.payrollCycle;
        /**
         * 时区
         * <p> 示例值：(GMT+08:00) 中国标准时间 - 上海
         */
        this.timeZone = builder.timeZone;
        /**
         * 发放日期
         * <p> 示例值：2022-01-01
         */
        this.payDate = builder.payDate;
        /**
         * 关联的算薪日历ID
         * <p> 示例值：7374707723663867948
         */
        this.payrollCalendarId = builder.payrollCalendarId;
        /**
         * 截止日期
         * <p> 示例值：2022-01-01
         */
        this.cutOffDate = builder.cutOffDate;
        /**
         * 税款所属年月
         * <p> 示例值：2023-10
         */
        this.taxablePeriod = builder.taxablePeriod;
        /**
         * 是否手动修改过
         * <p> 示例值：
         */
        this.manualModified = builder.manualModified;
        /**
         * 考勤开始日期
         * <p> 示例值：2024-01-01
         */
        this.attendanceStartDate = builder.attendanceStartDate;
        /**
         * 考勤结束日期
         * <p> 示例值：2024-01-31
         */
        this.attendanceEndDate = builder.attendanceEndDate;
        /**
         * 名单收集截止日
         * <p> 示例值：2024-01-26
         */
        this.cutOffDateForPaylist = builder.cutOffDateForPaylist;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getPeriodStartDate() {
        return this.periodStartDate;
    }

    public void setPeriodStartDate(String periodStartDate) {
        this.periodStartDate = periodStartDate;
    }

    public String getPeriodEndDate() {
        return this.periodEndDate;
    }

    public void setPeriodEndDate(String periodEndDate) {
        this.periodEndDate = periodEndDate;
    }

    public String getPeriodKey() {
        return this.periodKey;
    }

    public void setPeriodKey(String periodKey) {
        this.periodKey = periodKey;
    }

    public I18n getPeriodName() {
        return this.periodName;
    }

    public void setPeriodName(I18n periodName) {
        this.periodName = periodName;
    }

    public Integer getPayrollCycle() {
        return this.payrollCycle;
    }

    public void setPayrollCycle(Integer payrollCycle) {
        this.payrollCycle = payrollCycle;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getPayDate() {
        return this.payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getPayrollCalendarId() {
        return this.payrollCalendarId;
    }

    public void setPayrollCalendarId(String payrollCalendarId) {
        this.payrollCalendarId = payrollCalendarId;
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }

    public String getTaxablePeriod() {
        return this.taxablePeriod;
    }

    public void setTaxablePeriod(String taxablePeriod) {
        this.taxablePeriod = taxablePeriod;
    }

    public Boolean getManualModified() {
        return this.manualModified;
    }

    public void setManualModified(Boolean manualModified) {
        this.manualModified = manualModified;
    }

    public String getAttendanceStartDate() {
        return this.attendanceStartDate;
    }

    public void setAttendanceStartDate(String attendanceStartDate) {
        this.attendanceStartDate = attendanceStartDate;
    }

    public String getAttendanceEndDate() {
        return this.attendanceEndDate;
    }

    public void setAttendanceEndDate(String attendanceEndDate) {
        this.attendanceEndDate = attendanceEndDate;
    }

    public String getCutOffDateForPaylist() {
        return this.cutOffDateForPaylist;
    }

    public void setCutOffDateForPaylist(String cutOffDateForPaylist) {
        this.cutOffDateForPaylist = cutOffDateForPaylist;
    }

    public static class Builder {
        /**
         * 计薪周期开始日期
         * <p> 示例值：2022-01-01
         */
        private String periodStartDate;
        /**
         * 计薪周期结束日期
         * <p> 示例值：2022-01-01
         */
        private String periodEndDate;
        /**
         * 计薪周期key
         * <p> 示例值：2022-01
         */
        private String periodKey;
        /**
         * 计薪周期名称
         * <p> 示例值：
         */
        private I18n periodName;
        /**
         * 计薪周期类型
         * <p> 示例值：1
         */
        private Integer payrollCycle;
        /**
         * 时区
         * <p> 示例值：(GMT+08:00) 中国标准时间 - 上海
         */
        private String timeZone;
        /**
         * 发放日期
         * <p> 示例值：2022-01-01
         */
        private String payDate;
        /**
         * 关联的算薪日历ID
         * <p> 示例值：7374707723663867948
         */
        private String payrollCalendarId;
        /**
         * 截止日期
         * <p> 示例值：2022-01-01
         */
        private String cutOffDate;
        /**
         * 税款所属年月
         * <p> 示例值：2023-10
         */
        private String taxablePeriod;
        /**
         * 是否手动修改过
         * <p> 示例值：
         */
        private Boolean manualModified;
        /**
         * 考勤开始日期
         * <p> 示例值：2024-01-01
         */
        private String attendanceStartDate;
        /**
         * 考勤结束日期
         * <p> 示例值：2024-01-31
         */
        private String attendanceEndDate;
        /**
         * 名单收集截止日
         * <p> 示例值：2024-01-26
         */
        private String cutOffDateForPaylist;

        /**
         * 计薪周期开始日期
         * <p> 示例值：2022-01-01
         *
         * @param periodStartDate
         * @return
         */
        public Builder periodStartDate(String periodStartDate) {
            this.periodStartDate = periodStartDate;
            return this;
        }


        /**
         * 计薪周期结束日期
         * <p> 示例值：2022-01-01
         *
         * @param periodEndDate
         * @return
         */
        public Builder periodEndDate(String periodEndDate) {
            this.periodEndDate = periodEndDate;
            return this;
        }


        /**
         * 计薪周期key
         * <p> 示例值：2022-01
         *
         * @param periodKey
         * @return
         */
        public Builder periodKey(String periodKey) {
            this.periodKey = periodKey;
            return this;
        }


        /**
         * 计薪周期名称
         * <p> 示例值：
         *
         * @param periodName
         * @return
         */
        public Builder periodName(I18n periodName) {
            this.periodName = periodName;
            return this;
        }


        /**
         * 计薪周期类型
         * <p> 示例值：1
         *
         * @param payrollCycle
         * @return
         */
        public Builder payrollCycle(Integer payrollCycle) {
            this.payrollCycle = payrollCycle;
            return this;
        }


        /**
         * 时区
         * <p> 示例值：(GMT+08:00) 中国标准时间 - 上海
         *
         * @param timeZone
         * @return
         */
        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }


        /**
         * 发放日期
         * <p> 示例值：2022-01-01
         *
         * @param payDate
         * @return
         */
        public Builder payDate(String payDate) {
            this.payDate = payDate;
            return this;
        }


        /**
         * 关联的算薪日历ID
         * <p> 示例值：7374707723663867948
         *
         * @param payrollCalendarId
         * @return
         */
        public Builder payrollCalendarId(String payrollCalendarId) {
            this.payrollCalendarId = payrollCalendarId;
            return this;
        }


        /**
         * 截止日期
         * <p> 示例值：2022-01-01
         *
         * @param cutOffDate
         * @return
         */
        public Builder cutOffDate(String cutOffDate) {
            this.cutOffDate = cutOffDate;
            return this;
        }


        /**
         * 税款所属年月
         * <p> 示例值：2023-10
         *
         * @param taxablePeriod
         * @return
         */
        public Builder taxablePeriod(String taxablePeriod) {
            this.taxablePeriod = taxablePeriod;
            return this;
        }


        /**
         * 是否手动修改过
         * <p> 示例值：
         *
         * @param manualModified
         * @return
         */
        public Builder manualModified(Boolean manualModified) {
            this.manualModified = manualModified;
            return this;
        }


        /**
         * 考勤开始日期
         * <p> 示例值：2024-01-01
         *
         * @param attendanceStartDate
         * @return
         */
        public Builder attendanceStartDate(String attendanceStartDate) {
            this.attendanceStartDate = attendanceStartDate;
            return this;
        }


        /**
         * 考勤结束日期
         * <p> 示例值：2024-01-31
         *
         * @param attendanceEndDate
         * @return
         */
        public Builder attendanceEndDate(String attendanceEndDate) {
            this.attendanceEndDate = attendanceEndDate;
            return this;
        }


        /**
         * 名单收集截止日
         * <p> 示例值：2024-01-26
         *
         * @param cutOffDateForPaylist
         * @return
         */
        public Builder cutOffDateForPaylist(String cutOffDateForPaylist) {
            this.cutOffDateForPaylist = cutOffDateForPaylist;
            return this;
        }


        public CalendarPeriod build() {
            return new CalendarPeriod(this);
        }
    }
}
