/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.cache.ICache;
import com.lark.oapi.core.cache.LocalCache;
import com.lark.oapi.core.enums.AppType;
import com.lark.oapi.core.enums.BaseUrlEnum;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.httpclient.OkHttpTransport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.token.AppTicketManager;
import com.lark.oapi.core.token.GlobalAppTicketManager;
import com.lark.oapi.core.token.GlobalTokenManager;
import com.lark.oapi.core.token.TokenManager;
import com.lark.oapi.core.utils.OKHttps;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.service.acs.AcsService;
import com.lark.oapi.service.admin.AdminService;
import com.lark.oapi.service.aily.AilyService;
import com.lark.oapi.service.apaas.ApaasService;
import com.lark.oapi.service.application.ApplicationService;
import com.lark.oapi.service.approval.ApprovalService;
import com.lark.oapi.service.attendance.AttendanceService;
import com.lark.oapi.service.auth.AuthService;
import com.lark.oapi.service.authen.AuthenService;
import com.lark.oapi.service.baike.BaikeService;
import com.lark.oapi.service.bitable.BitableService;
import com.lark.oapi.service.block.BlockService;
import com.lark.oapi.service.board.BoardService;
import com.lark.oapi.service.calendar.CalendarService;
import com.lark.oapi.service.cardkit.CardkitService;
import com.lark.oapi.service.compensation.CompensationService;
import com.lark.oapi.service.contact.ContactService;
import com.lark.oapi.service.corehr.CorehrService;
import com.lark.oapi.service.docs.DocsService;
import com.lark.oapi.service.document_ai.DocumentAiService;
import com.lark.oapi.service.docx.DocxService;
import com.lark.oapi.service.drive.DriveService;
import com.lark.oapi.service.ehr.EhrService;
import com.lark.oapi.service.event.EventService;
import com.lark.oapi.service.ext.ExtService;
import com.lark.oapi.service.helpdesk.HelpdeskService;
import com.lark.oapi.service.hire.HireService;
import com.lark.oapi.service.human_authentication.HumanAuthenticationService;
import com.lark.oapi.service.im.ImService;
import com.lark.oapi.service.lingo.LingoService;
import com.lark.oapi.service.mail.MailService;
import com.lark.oapi.service.mdm.MdmService;
import com.lark.oapi.service.meeting_room.MeetingRoomService;
import com.lark.oapi.service.minutes.MinutesService;
import com.lark.oapi.service.moments.MomentsService;
import com.lark.oapi.service.okr.OkrService;
import com.lark.oapi.service.optical_char_recognition.OpticalCharRecognitionService;
import com.lark.oapi.service.passport.PassportService;
import com.lark.oapi.service.payroll.PayrollService;
import com.lark.oapi.service.performance.PerformanceService;
import com.lark.oapi.service.personal_settings.PersonalSettingsService;
import com.lark.oapi.service.report.ReportService;
import com.lark.oapi.service.search.SearchService;
import com.lark.oapi.service.security_and_compliance.SecurityAndComplianceService;
import com.lark.oapi.service.sheets.SheetsService;
import com.lark.oapi.service.speech_to_text.SpeechToTextService;
import com.lark.oapi.service.task.TaskService;
import com.lark.oapi.service.tenant.TenantService;
import com.lark.oapi.service.translation.TranslationService;
import com.lark.oapi.service.vc.VcService;
import com.lark.oapi.service.verification.VerificationService;
import com.lark.oapi.service.wiki.WikiService;
import com.lark.oapi.service.workplace.WorkplaceService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class Client {
    private Config config;
    private SearchService search;
    private VerificationService verification;
    private CalendarService calendar;
    private HumanAuthenticationService humanAuthentication;
    private SheetsService sheets;
    private SpeechToTextService speechToText;
    private TenantService tenant;
    private WorkplaceService workplace;
    private DocxService docx;
    private HireService hire;
    private SecurityAndComplianceService securityAndCompliance;
    private TaskService task;
    private TranslationService translation;
    private BoardService board;
    private CompensationService compensation;
    private DocumentAiService documentAi;
    private EhrService ehr;
    private MeetingRoomService meetingRoom;
    private PerformanceService performance;
    private AdminService admin;
    private ApprovalService approval;
    private AttendanceService attendance;
    private DriveService drive;
    private MomentsService moments;
    private OkrService okr;
    private AuthenService authen;
    private BaikeService baike;
    private CardkitService cardkit;
    private DocsService docs;
    private OpticalCharRecognitionService opticalCharRecognition;
    private PersonalSettingsService personalSettings;
    private VcService vc;
    private WikiService wiki;
    private AcsService acs;
    private ApplicationService application;
    private AuthService auth;
    private EventService event;
    private HelpdeskService helpdesk;
    private ImService im;
    private MinutesService minutes;
    private PassportService passport;
    private AilyService aily;
    private ApaasService apaas;
    private BlockService block;
    private ContactService contact;
    private LingoService lingo;
    private MailService mail;
    private MdmService mdm;
    private PayrollService payroll;
    private BitableService bitable;
    private CorehrService corehr;
    private ReportService report;
    private ExtService extService;

    public static Builder newBuilder(String appId, String appSecret) {
        return new Builder(appId, appSecret);
    }

    public ExtService ext() {
        return this.extService;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public SearchService search() {
        return this.search;
    }

    public VerificationService verification() {
        return this.verification;
    }

    public CalendarService calendar() {
        return this.calendar;
    }

    public HumanAuthenticationService humanAuthentication() {
        return this.humanAuthentication;
    }

    public SheetsService sheets() {
        return this.sheets;
    }

    public SpeechToTextService speechToText() {
        return this.speechToText;
    }

    public TenantService tenant() {
        return this.tenant;
    }

    public WorkplaceService workplace() {
        return this.workplace;
    }

    public DocxService docx() {
        return this.docx;
    }

    public HireService hire() {
        return this.hire;
    }

    public SecurityAndComplianceService securityAndCompliance() {
        return this.securityAndCompliance;
    }

    public TaskService task() {
        return this.task;
    }

    public TranslationService translation() {
        return this.translation;
    }

    public BoardService board() {
        return this.board;
    }

    public CompensationService compensation() {
        return this.compensation;
    }

    public DocumentAiService documentAi() {
        return this.documentAi;
    }

    public EhrService ehr() {
        return this.ehr;
    }

    public MeetingRoomService meetingRoom() {
        return this.meetingRoom;
    }

    public PerformanceService performance() {
        return this.performance;
    }

    public AdminService admin() {
        return this.admin;
    }

    public ApprovalService approval() {
        return this.approval;
    }

    public AttendanceService attendance() {
        return this.attendance;
    }

    public DriveService drive() {
        return this.drive;
    }

    public MomentsService moments() {
        return this.moments;
    }

    public OkrService okr() {
        return this.okr;
    }

    public AuthenService authen() {
        return this.authen;
    }

    public BaikeService baike() {
        return this.baike;
    }

    public CardkitService cardkit() {
        return this.cardkit;
    }

    public DocsService docs() {
        return this.docs;
    }

    public OpticalCharRecognitionService opticalCharRecognition() {
        return this.opticalCharRecognition;
    }

    public PersonalSettingsService personalSettings() {
        return this.personalSettings;
    }

    public VcService vc() {
        return this.vc;
    }

    public WikiService wiki() {
        return this.wiki;
    }

    public AcsService acs() {
        return this.acs;
    }

    public ApplicationService application() {
        return this.application;
    }

    public AuthService auth() {
        return this.auth;
    }

    public EventService event() {
        return this.event;
    }

    public HelpdeskService helpdesk() {
        return this.helpdesk;
    }

    public ImService im() {
        return this.im;
    }

    public MinutesService minutes() {
        return this.minutes;
    }

    public PassportService passport() {
        return this.passport;
    }

    public AilyService aily() {
        return this.aily;
    }

    public ApaasService apaas() {
        return this.apaas;
    }

    public BlockService block() {
        return this.block;
    }

    public ContactService contact() {
        return this.contact;
    }

    public LingoService lingo() {
        return this.lingo;
    }

    public MailService mail() {
        return this.mail;
    }

    public MdmService mdm() {
        return this.mdm;
    }

    public PayrollService payroll() {
        return this.payroll;
    }

    public BitableService bitable() {
        return this.bitable;
    }

    public CorehrService corehr() {
        return this.corehr;
    }

    public ReportService report() {
        return this.report;
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public static final class Builder {
        private Config config = new Config();

        public Builder(String appId, String appSecret) {
            this.config.setAppId(appId);
            this.config.setAppSecret(appSecret);
            this.config.setBaseUrl(BaseUrlEnum.FeiShu.getUrl());
            this.config.setAppType(AppType.SELF_BUILT);
            this.config.setDisableTokenCache(false);
        }

        public Builder helpDeskCredential(String helpDeskId, String helpDeskToken) {
            this.config.setHelpDeskToken(helpDeskToken);
            this.config.setHelpDeskID(helpDeskId);
            if (Strings.isNotEmpty(helpDeskId) && Strings.isNotEmpty(helpDeskToken)) {
                this.config.setHelpDeskAuthToken(Base64.getEncoder().encodeToString(String.format("%s:%s", helpDeskId, helpDeskToken).getBytes(StandardCharsets.UTF_8)));
            }
            return this;
        }

        public Builder appType(AppType appType) {
            this.config.setAppType(appType);
            return this;
        }

        public Builder marketplaceApp() {
            this.config.setAppType(AppType.MARKETPLACE);
            return this;
        }

        public Builder disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder logReqAtDebug(boolean logReqRespInfoAtDebugLevel) {
            this.config.setLogReqAtDebug(logReqRespInfoAtDebugLevel);
            return this;
        }

        public Builder openBaseUrl(String baseUrl) {
            this.config.setBaseUrl(baseUrl);
            return this;
        }

        public Builder openBaseUrl(BaseUrlEnum baseUrl) {
            this.config.setBaseUrl(baseUrl.getUrl());
            return this;
        }

        public Builder tokenCache(ICache cache) {
            this.config.setCache(cache);
            return this;
        }

        public Builder requestTimeout(long timeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(timeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this;
        }

        public Builder httpTransport(IHttpTransport httpTransport) {
            this.config.setHttpTransport(httpTransport);
            return this;
        }

        private void initCache(Config config) {
            if (config.getCache() != null) {
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(config.getCache()));
                GlobalTokenManager.setTokenManager(new TokenManager(config.getCache()));
            } else {
                LocalCache cache = LocalCache.getInstance();
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(cache));
                GlobalTokenManager.setTokenManager(new TokenManager(cache));
            }
        }

        private void initHttpTransport(Config config) {
            if (config.getHttpTransport() == null) {
                if (config.getRequestTimeOut() > 0L) {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.create(config.getRequestTimeOut(), config.getTimeOutTimeUnit())));
                } else {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.defaultClient));
                }
            }
        }

        public Client build() {
            Client client = new Client();
            client.setConfig(this.config);
            this.initCache(this.config);
            this.initHttpTransport(this.config);
            client.extService = new ExtService(this.config);
            client.search = new SearchService(this.config);
            client.verification = new VerificationService(this.config);
            client.calendar = new CalendarService(this.config);
            client.humanAuthentication = new HumanAuthenticationService(this.config);
            client.sheets = new SheetsService(this.config);
            client.speechToText = new SpeechToTextService(this.config);
            client.tenant = new TenantService(this.config);
            client.workplace = new WorkplaceService(this.config);
            client.docx = new DocxService(this.config);
            client.hire = new HireService(this.config);
            client.securityAndCompliance = new SecurityAndComplianceService(this.config);
            client.task = new TaskService(this.config);
            client.translation = new TranslationService(this.config);
            client.board = new BoardService(this.config);
            client.compensation = new CompensationService(this.config);
            client.documentAi = new DocumentAiService(this.config);
            client.ehr = new EhrService(this.config);
            client.meetingRoom = new MeetingRoomService(this.config);
            client.performance = new PerformanceService(this.config);
            client.admin = new AdminService(this.config);
            client.approval = new ApprovalService(this.config);
            client.attendance = new AttendanceService(this.config);
            client.drive = new DriveService(this.config);
            client.moments = new MomentsService(this.config);
            client.okr = new OkrService(this.config);
            client.authen = new AuthenService(this.config);
            client.baike = new BaikeService(this.config);
            client.cardkit = new CardkitService(this.config);
            client.docs = new DocsService(this.config);
            client.opticalCharRecognition = new OpticalCharRecognitionService(this.config);
            client.personalSettings = new PersonalSettingsService(this.config);
            client.vc = new VcService(this.config);
            client.wiki = new WikiService(this.config);
            client.acs = new AcsService(this.config);
            client.application = new ApplicationService(this.config);
            client.auth = new AuthService(this.config);
            client.event = new EventService(this.config);
            client.helpdesk = new HelpdeskService(this.config);
            client.im = new ImService(this.config);
            client.minutes = new MinutesService(this.config);
            client.passport = new PassportService(this.config);
            client.aily = new AilyService(this.config);
            client.apaas = new ApaasService(this.config);
            client.block = new BlockService(this.config);
            client.contact = new ContactService(this.config);
            client.lingo = new LingoService(this.config);
            client.mail = new MailService(this.config);
            client.mdm = new MdmService(this.config);
            client.payroll = new PayrollService(this.config);
            client.bitable = new BitableService(this.config);
            client.corehr = new CorehrService(this.config);
            client.report = new ReportService(this.config);
            return client;
        }
    }
}

